/*
 * Decompiled with CFR 0.152.
 */
package com.sovdee.skriptparticles.elements.expressions.properties;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.PropertyExpression;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import com.sovdee.skriptparticles.shapes.Shape;
import com.sovdee.skriptparticles.util.Quaternion;
import org.bukkit.event.Event;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.Nullable;

@Name(value="Normal Vector of Shape")
@Description(value={"Returns the normal vector of a shape. This, by default, is the vector (0, 1, 0) which points directly up.If the shape is rotated, this will be the vector that is pointing up after the rotation. Treat it as what the shape thinks is \"up\".", "Changing this will rotate the shape accordingly. Resetting or deleting it will set it back to the default orientation."})
@Examples(value={"set {_shape}'s normal vector to vector(1, 0, 0)", "set {_v} to {_shape}'s normal", "reset {_shape}'s normal vector"})
@Since(value={"1.0.0"})
public class ExprShapeNormal
extends SimplePropertyExpression<Shape, Vector> {
    public Vector convert(Shape shape) {
        return shape.getRelativeYAxis(false);
    }

    @Nullable
    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        Class[] classArray;
        switch (mode) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case SET: 
            case RESET: 
            case DELETE: {
                Class[] classArray2 = new Class[1];
                classArray = classArray2;
                classArray2[0] = Vector.class;
                break;
            }
            case ADD: 
            case REMOVE: 
            case REMOVE_ALL: {
                classArray = new Class[]{};
            }
        }
        return classArray;
    }

    public void change(Event event, Object @Nullable [] delta, Changer.ChangeMode mode) {
        switch (mode) {
            case SET: {
                if (delta == null || delta.length == 0) {
                    return;
                }
                for (Shape shape : (Shape[])this.getExpr().getArray(event)) {
                    shape.setOrientation(new Quaternion().rotationTo((Vector)delta[0]));
                }
                break;
            }
            case RESET: 
            case DELETE: {
                for (Shape shape : (Shape[])this.getExpr().getArray(event)) {
                    shape.setOrientation(Quaternion.IDENTITY);
                }
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
    }

    public Class<? extends Vector> getReturnType() {
        return Vector.class;
    }

    protected String getPropertyName() {
        return "normal vector or relative y-axis";
    }

    static {
        PropertyExpression.register(ExprShapeNormal.class, Vector.class, (String)"normal [vector]", (String)"shapes");
    }
}

