/*
 * Decompiled with CFR 0.152.
 */
package com.sovdee.skriptparticles.elements.expressions.properties;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.expressions.base.PropertyExpression;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import com.sovdee.skriptparticles.shapes.Shape;
import org.bukkit.event.Event;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Shape Offset")
@Description(value={"Returns the offset vector of a shape. This is the vector that is added to the location of the shape before drawing.", "Changing this will move the shape accordingly. Resetting or deleting it will set it back to the default offset of (0, 0, 0)."})
@Examples(value={"set {_shape}'s offset vector to vector(1, 0, 0)", "set offset of {_shape} to vector(0, 10, 0)", "reset {_shape}'s offset vector"})
public class ExprShapeOffset
extends SimplePropertyExpression<Shape, Vector> {
    @Nullable
    public Vector convert(Shape shape) {
        return shape.getOffset();
    }

    @Nullable
    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        Class[] classArray;
        switch (mode) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case SET: 
            case RESET: 
            case DELETE: {
                Class[] classArray2 = new Class[1];
                classArray = classArray2;
                classArray2[0] = Vector.class;
                break;
            }
            case ADD: 
            case REMOVE: 
            case REMOVE_ALL: {
                classArray = new Class[]{};
            }
        }
        return classArray;
    }

    public void change(Event event, Object @Nullable [] delta, Changer.ChangeMode mode) {
        switch (mode) {
            case SET: {
                if (delta == null || delta.length == 0) {
                    return;
                }
                for (Shape shape : (Shape[])this.getExpr().getArray(event)) {
                    shape.setOffset((Vector)delta[0]);
                }
                break;
            }
            case RESET: 
            case DELETE: {
                for (Shape shape : (Shape[])this.getExpr().getArray(event)) {
                    shape.setOffset(new Vector(0, 0, 0));
                }
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
    }

    @NotNull
    public Class<? extends Vector> getReturnType() {
        return Vector.class;
    }

    @NotNull
    protected String getPropertyName() {
        return "offset vector of shapes";
    }

    static {
        PropertyExpression.register(ExprShapeOffset.class, Vector.class, (String)"offset [vector]", (String)"shapes");
    }
}

