/*
 * Decompiled with CFR 0.152.
 */
package com.sovdee.skriptparticles.elements.expressions.properties;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.PropertyExpression;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import com.sovdee.skriptparticles.shapes.Shape;
import com.sovdee.skriptparticles.util.Quaternion;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Shape Orientation")
@Description(value={"The orientation of a shape. This is the rotation that is applied to the shape before drawing.", "Changing this will rotate the shape accordingly. Resetting or deleting it will set it back to the default orientation of (0, 0, 0, 1).", "The expression returns a quaternion. You can use the quaternion and axis angle functions or the rotation expression to create an orientation."})
@Examples(value={"set {_shape}'s orientation to quaternion(0, 0, 0, 1)", "set {_shape}'s orientation to axisAngle(90, 0, 1, 0)", "set {_shape}'s orientation to {_shape2}'s orientation", "reset {_shape}'s orientation"})
@Since(value={"1.0.0"})
public class ExprShapeOrientation
extends SimplePropertyExpression<Shape, Quaternion> {
    @Nullable
    public Quaternion convert(Shape shape) {
        return shape.getOrientation();
    }

    @Nullable
    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        Class[] classArray;
        switch (mode) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case SET: 
            case RESET: 
            case DELETE: {
                Class[] classArray2 = new Class[1];
                classArray = classArray2;
                classArray2[0] = Quaternion.class;
                break;
            }
            case ADD: 
            case REMOVE: 
            case REMOVE_ALL: {
                classArray = new Class[]{};
            }
        }
        return classArray;
    }

    public void change(Event event, Object @Nullable [] delta, Changer.ChangeMode mode) {
        switch (mode) {
            case SET: {
                if (delta == null || delta.length == 0) {
                    return;
                }
                for (Shape shape : (Shape[])this.getExpr().getArray(event)) {
                    shape.setOrientation((Quaternion)delta[0]);
                }
                break;
            }
            case RESET: 
            case DELETE: {
                for (Shape shape : (Shape[])this.getExpr().getArray(event)) {
                    shape.setOrientation(Quaternion.IDENTITY);
                }
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
    }

    public Class<? extends Quaternion> getReturnType() {
        return Quaternion.class;
    }

    @NotNull
    protected String getPropertyName() {
        return "orientation";
    }

    static {
        PropertyExpression.register(ExprShapeOrientation.class, Quaternion.class, (String)"orientation", (String)"shapes");
    }
}

