/*
 * Decompiled with CFR 0.152.
 */
package com.sovdee.skriptparticles.elements.expressions.properties;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.PropertyExpression;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import com.sovdee.skriptparticles.particles.Particle;
import com.sovdee.skriptparticles.shapes.Shape;
import com.sovdee.skriptparticles.util.ParticleUtil;
import org.bukkit.event.Event;
import org.jetbrains.annotations.Nullable;

@Name(value="Shape Particle")
@Description(value={"The particle of a shape. This is the particle that the shape uses to draw itself.", "Changing this will change the particle of the shape. Resetting or deleting it will set it back to the default particle (flame).", "You can set the particle to any base or custom particle."})
@Examples(value={"set {_shape}'s particle to flame", "set {_shape}'s particle to 1 of electric spark with extra 0", "reset {_shape}'s particle", "", "create a new custom particle:", "\tparticle: soul fire flame", "\tvelocity: inwards", "\textra: 0.5", "\tforce: true", "set {_shape}'s particle to the last created particle"})
@Since(value={"1.0.0"})
public class ExprShapeParticle
extends SimplePropertyExpression<Shape, Particle> {
    @Nullable
    public Particle convert(Shape shape) {
        return shape.getParticle();
    }

    @Nullable
    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        Class[] classArray;
        switch (mode) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case SET: 
            case RESET: 
            case DELETE: {
                Class[] classArray2 = new Class[1];
                classArray = classArray2;
                classArray2[0] = Particle.class;
                break;
            }
            case ADD: 
            case REMOVE: 
            case REMOVE_ALL: {
                classArray = new Class[]{};
            }
        }
        return classArray;
    }

    public void change(Event event, Object @Nullable [] delta, Changer.ChangeMode mode) {
        switch (mode) {
            case SET: {
                if (delta == null || delta.length == 0) {
                    return;
                }
                for (Shape shape : (Shape[])this.getExpr().getArray(event)) {
                    shape.setParticle((Particle)((Object)delta[0]));
                }
                break;
            }
            case RESET: 
            case DELETE: {
                for (Shape shape : (Shape[])this.getExpr().getArray(event)) {
                    shape.setParticle(ParticleUtil.getDefaultParticle());
                }
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
    }

    public Class<? extends Particle> getReturnType() {
        return Particle.class;
    }

    protected String getPropertyName() {
        return "custom particle";
    }

    static {
        PropertyExpression.register(ExprShapeParticle.class, Particle.class, (String)"[custom] particle", (String)"shapes");
    }
}

