/*
 * Decompiled with CFR 0.152.
 */
package com.sovdee.skriptparticles.elements.expressions.properties;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.PropertyExpression;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.sovdee.skriptparticles.shapes.Shape;
import com.sovdee.skriptparticles.util.MathUtil;
import org.bukkit.event.Event;
import org.jetbrains.annotations.Nullable;

@Name(value="Shape Particle Density / Particle Count")
@Description(value={"The density at which particles are spawned in a shape. This is in \"particles per meter\" (ppm), and defaults to 4.Be careful with this property, as it can cause lag if set to a high number. It's recommended to not go above 20 or so for this reason. 1000 ppm is the maximum value.", "Keep in mind that this value scales with dimensions. A 1 meter line with a density of 20 will spawn 20 particles, but a 1 meter cube with a density of 20 will spawn 8,000 particles (2,400 if hollow).", "Also, be aware that this may not be exact. Some shapes, like cuboids, will tweak the density a bit to ensure particles land exactly on the borders of the shape.", "", "This syntax also supports setting the particle count directly, which is the amount of particles spawned in a shape.", "Note that this is NOT exact. The actual amount of particles spawned will be the closest multiple of the particle count to the amount of particles needed to draw the shape.", "For example, if the particle count of a solid cube is set to 100, the actual amount of particles spawned will be 125, which is the nearest cubic number.", "The returned value of this expression will always be the accurate amount of particles spawned in a shape.", "", "Changing this will change the particle density or count of the shape. Resetting or deleting it will set it back to the default density (4)."})
@Examples(value={"set {_shape}'s particle density to 10", "set {_shape}'s particle count to 100", "reset {_shape}'s particle density", "reset {_shape}'s particle count"})
@Since(value={"1.0.0"})
public class ExprShapeParticleDensity
extends SimplePropertyExpression<Shape, Number> {
    private boolean isDensity;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.isDensity = parseResult.hasTag("density");
        return super.init(exprs, matchedPattern, isDelayed, parseResult);
    }

    @Nullable
    public Number convert(Shape shape) {
        if (this.isDensity) {
            return 1.0 / shape.getParticleDensity();
        }
        return shape.getParticleCount();
    }

    @Nullable
    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        Class[] classArray;
        switch (mode) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case ADD: 
            case REMOVE: 
            case SET: 
            case RESET: 
            case DELETE: {
                Class[] classArray2 = new Class[1];
                classArray = classArray2;
                classArray2[0] = Number.class;
                break;
            }
            case REMOVE_ALL: {
                classArray = new Class[]{};
            }
        }
        return classArray;
    }

    public void change(Event event, Object @Nullable [] delta, Changer.ChangeMode mode) {
        Shape[] shapes = (Shape[])this.getExpr().getArray(event);
        if (shapes.length == 0) {
            return;
        }
        double change = delta == null ? 0.25 : ((Number)delta[0]).doubleValue();
        switch (mode) {
            case REMOVE: {
                change = -change;
            }
            case ADD: {
                for (Shape shape : shapes) {
                    if (this.isDensity) {
                        shape.setParticleDensity(MathUtil.clamp(1.0 / (1.0 / shape.getParticleDensity() + change), 0.001, 1000.0));
                        continue;
                    }
                    shape.setParticleCount(Math.max(1, shape.getParticleCount() + (int)change));
                }
                break;
            }
            case SET: 
            case RESET: 
            case DELETE: {
                change = this.isDensity ? MathUtil.clamp(1.0 / change, 0.001, 1000.0) : (double)Math.max(1, (int)change);
                for (Shape shape : shapes) {
                    if (this.isDensity) {
                        shape.setParticleDensity(change);
                        continue;
                    }
                    shape.setParticleCount((int)change);
                }
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
    }

    public Class<? extends Number> getReturnType() {
        return Number.class;
    }

    protected String getPropertyName() {
        return "particle " + (this.isDensity ? "density" : "count");
    }

    static {
        PropertyExpression.register(ExprShapeParticleDensity.class, Number.class, (String)"particle (:density|:count)", (String)"shapes");
    }
}

