/*
 * Decompiled with CFR 0.152.
 */
package com.sovdee.skriptparticles.elements.expressions.properties;

import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.PropertyExpression;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.sovdee.skriptparticles.shapes.Shape;
import java.util.ArrayList;
import org.bukkit.event.Event;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.Nullable;

@Name(value="Shape Points")
@Description(value={"Returns all the vectors from the center of the shape to the various points particles would be drawn at.", "If you want the locations of the particles, it's advised use the 'shape locations' expression rather than doing it yourself."})
@Examples(value={"set {_vectors::*} to points of (circle of radius 10)", "teleport player to (player ~ random element of {_vectors::*})", "", "set {_randomVectorInEllipsoid} to random element of points of (solid ellipsoid of radius 10, 5, 2)"})
@Since(value={"1.0.0"})
public class ExprShapePoints
extends PropertyExpression<Shape, Vector> {
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.setExpr(exprs[0]);
        return true;
    }

    protected Vector[] get(Event event, Shape[] source) {
        ArrayList<Vector> points = new ArrayList<Vector>();
        for (Shape shape : source) {
            points.addAll(shape.getPoints());
        }
        return points.toArray(new Vector[0]);
    }

    public boolean isSingle() {
        return false;
    }

    public Class<? extends Vector> getReturnType() {
        return Vector.class;
    }

    public String toString(@Nullable Event event, boolean debug) {
        return "points of " + this.getExpr().toString(event, debug);
    }

    static {
        ExprShapePoints.register(ExprShapePoints.class, Vector.class, (String)"points", (String)"shapes");
    }
}

