/*
 * Decompiled with CFR 0.152.
 */
package com.sovdee.skriptparticles.elements.expressions.properties;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.PropertyExpression;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import com.sovdee.skriptparticles.shapes.RadialShape;
import org.bukkit.event.Event;
import org.jetbrains.annotations.Nullable;

@Name(value="Shape Radius")
@Description(value={"The radius of a shape. For circular or spherical shapes, this is the distance from the center to the edge. For shapes like regular polygons, this is the distance from the center to a corner.", "Changing this will change the size of the shape. Resetting or deleting it will set it back to the default radius of 1."})
@Examples(value={"set {_shape}'s radius to 5", "set radius of {_shape} to 10", "reset {_shape}'s radius"})
@Since(value={"1.0.0"})
public class ExprShapeRadius
extends SimplePropertyExpression<RadialShape, Number> {
    @Nullable
    public Number convert(RadialShape shape) {
        return shape.getRadius();
    }

    @Nullable
    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        Class[] classArray;
        switch (mode) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case SET: 
            case RESET: 
            case DELETE: 
            case ADD: 
            case REMOVE: {
                Class[] classArray2 = new Class[1];
                classArray = classArray2;
                classArray2[0] = Number.class;
                break;
            }
            case REMOVE_ALL: {
                classArray = new Class[]{};
            }
        }
        return classArray;
    }

    public void change(Event event, Object @Nullable [] delta, Changer.ChangeMode mode) {
        RadialShape[] radialShapes = (RadialShape[])this.getExpr().getArray(event);
        if (radialShapes.length == 0) {
            return;
        }
        double deltaValue = delta != null ? ((Number)delta[0]).doubleValue() : 1.0;
        switch (mode) {
            case REMOVE: {
                deltaValue = -deltaValue;
            }
            case ADD: {
                for (RadialShape shape : radialShapes) {
                    shape.setRadius(Math.max(0.001, shape.getRadius() + deltaValue));
                }
                break;
            }
            case SET: 
            case RESET: 
            case DELETE: {
                deltaValue = Math.max(0.001, deltaValue);
                for (RadialShape shape : radialShapes) {
                    shape.setRadius(deltaValue);
                }
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
    }

    public Class<? extends Number> getReturnType() {
        return Number.class;
    }

    protected String getPropertyName() {
        return "radius";
    }

    static {
        PropertyExpression.register(ExprShapeRadius.class, Number.class, (String)"radius", (String)"radialshapes");
    }
}

