/*
 * Decompiled with CFR 0.152.
 */
package com.sovdee.skriptparticles.elements.expressions.properties;

import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.PropertyExpression;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.sovdee.skriptparticles.shapes.Shape;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.Nullable;

@Name(value="Shape Relative Axis")
@Description(value={"Returns the relative axis of a shape. These are the x, y, z axis of the shape AFTER rotation.", "These are meant to be used to work within the rotated frame of reference of the shape."})
@Examples(value={"set {_vX} to {_shape}'s relative x axis", "set {_vY} to {_shape}'s relative y axis", "set {_vZ} to {_shape}'s relative z axis", "rotate shape {_shape} around {_vy} by 90 degrees", "set {_vY-offset} to {_shape}'s relative y axis ++ {_shape}'s relative z axis", "rotate shape {_shape} around {_vY-offset} by 60 degrees"})
@Since(value={"1.0.0"})
public class ExprShapeRelativeAxis
extends SimplePropertyExpression<Shape, Vector> {
    private int axis;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.axis = parseResult.hasTag("x") ? 0 : (parseResult.hasTag("y") ? 1 : 2);
        return super.init(exprs, matchedPattern, isDelayed, parseResult);
    }

    @Nullable
    public Vector convert(Shape shape) {
        return switch (this.axis) {
            case 0 -> shape.getRelativeXAxis(false);
            case 1 -> shape.getRelativeYAxis(false);
            case 2 -> shape.getRelativeZAxis(false);
            default -> null;
        };
    }

    public Class<? extends Vector> getReturnType() {
        return Vector.class;
    }

    protected String getPropertyName() {
        return "relative axis " + this.axis;
    }

    static {
        PropertyExpression.register(ExprShapeRelativeAxis.class, Vector.class, (String)"(relative|local) (:x|:y|:z)(-| )axis", (String)"shapes");
    }
}

