/*
 * Decompiled with CFR 0.152.
 */
package com.sovdee.skriptparticles.elements.expressions.properties;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.PropertyExpression;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import com.sovdee.skriptparticles.shapes.Shape;
import org.bukkit.event.Event;
import org.jetbrains.annotations.Nullable;

@Name(value="Shape Scale")
@Description(value={"Returns the scale of a shape. This is will scale the shape up or down accordingly, with respect to its center.", "This does not affect the number of particles drawn, so a scaled up shape will look more sparse. A negative scale will flip the shape inside-out.", "Changing this will scale the shape accordingly. Resetting or deleting it will set it back to the default scale of 1."})
@Examples(value={"set {_shape}'s shape scale to 2", "set shape scale of {_shape} to 0.5", "set shape scale of {_shape} to 2 * (scale of {_shape})", "reset {_shape}'s shape scale"})
@Since(value={"1.0.0"})
public class ExprShapeScale
extends SimplePropertyExpression<Shape, Number> {
    @Nullable
    public Number convert(Shape shape) {
        return shape.getScale();
    }

    @Nullable
    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        Class[] classArray;
        switch (mode) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case SET: 
            case RESET: 
            case DELETE: 
            case ADD: 
            case REMOVE: {
                Class[] classArray2 = new Class[1];
                classArray = classArray2;
                classArray2[0] = Number.class;
                break;
            }
            case REMOVE_ALL: {
                classArray = new Class[]{};
            }
        }
        return classArray;
    }

    public void change(Event event, Object @Nullable [] delta, Changer.ChangeMode mode) {
        if (!(mode != Changer.ChangeMode.ADD && mode != Changer.ChangeMode.SET && mode != Changer.ChangeMode.REMOVE || delta != null && delta.length != 0)) {
            return;
        }
        Shape[] shapes = (Shape[])this.getExpr().getArray(event);
        if (shapes.length == 0) {
            return;
        }
        double change = delta != null ? ((Number)delta[0]).doubleValue() : 1.0;
        switch (mode) {
            case REMOVE: {
                change = -change;
            }
            case ADD: {
                for (Shape shape : shapes) {
                    shape.setScale(shape.getScale() + change);
                }
                break;
            }
            case SET: 
            case RESET: 
            case DELETE: {
                for (Shape shape : shapes) {
                    shape.setScale(change);
                }
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
    }

    public Class<? extends Number> getReturnType() {
        return Number.class;
    }

    protected String getPropertyName() {
        return "scale";
    }

    static {
        PropertyExpression.register(ExprShapeScale.class, Number.class, (String)"shape scale", (String)"shapes");
    }
}

