/*
 * Decompiled with CFR 0.152.
 */
package com.sovdee.skriptparticles.elements.expressions.properties;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import com.sovdee.skriptparticles.shapes.PolyShape;
import org.bukkit.event.Event;
import org.jetbrains.annotations.Nullable;

@Name(value="Shape Side Length - Polygonal/Polyhedral")
@Description(value={"Returns the side length of a polygonal/polyhedral shape. This determines how long each side of the shape is.", "Changing this will change the side length of the shape accordingly. Likewise, this changes the radius of the shape. Resetting this will set the side length to the default value of 1 and non-positive values will be set to 0.001.", "Note that changing this property will not affect custom polygons, only regular polygons and polyhedrons."})
@Examples(value={"set side length of {_shape} to 5", "set {_shape}'s side length to 6", "send side length of {_shape}"})
@Since(value={"1.0.0"})
public class ExprShapeSideLength
extends SimplePropertyExpression<PolyShape, Number> {
    @Nullable
    public Number convert(PolyShape polyShape) {
        return polyShape.getSideLength();
    }

    @Nullable
    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        Class[] classArray;
        switch (mode) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case SET: 
            case ADD: 
            case REMOVE: 
            case DELETE: 
            case RESET: {
                Class[] classArray2 = new Class[1];
                classArray = classArray2;
                classArray2[0] = Number.class;
                break;
            }
            case REMOVE_ALL: {
                classArray = new Class[]{};
            }
        }
        return classArray;
    }

    public void change(Event event, Object @Nullable [] delta, Changer.ChangeMode mode) {
        double change = delta != null ? ((Number)delta[0]).doubleValue() : 1.0;
        switch (mode) {
            case REMOVE: {
                change = -change;
            }
            case ADD: {
                for (PolyShape polyShape : (PolyShape[])this.getExpr().getArray(event)) {
                    polyShape.setSideLength(Math.max(0.001, polyShape.getSideLength() + change));
                }
                break;
            }
            case SET: 
            case DELETE: 
            case RESET: {
                change = Math.max(0.001, change);
                for (PolyShape polyShape : (PolyShape[])this.getExpr().getArray(event)) {
                    polyShape.setSideLength(change);
                }
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
    }

    public Class<? extends Number> getReturnType() {
        return Number.class;
    }

    protected String getPropertyName() {
        return "side length";
    }

    static {
        ExprShapeSideLength.register(ExprShapeSideLength.class, Number.class, (String)"side length", (String)"polyshapes");
    }
}

