/*
 * Decompiled with CFR 0.152.
 */
package com.sovdee.skriptparticles.elements.expressions.properties;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import com.sovdee.skriptparticles.shapes.PolyShape;
import org.bukkit.event.Event;
import org.jetbrains.annotations.Nullable;

@Name(value="Shape Side Count - Polygonal/Polyhedral")
@Description(value={"Returns the number of sides of a polygonal or polyhedral shape. This determines how many sides the shape has.", "Changing this will change the number of sides of the shape accordingly, with a minimum of 3.", "Note that custom polygons will return their side count, but will not be affected by this expression. ", "Polyhedrons will return their face count, and can only be set to 4, 8, 12, or 20."})
@Examples(value={"set sides of {_shape} to 5", "set {_shape}'s side count to 6", "send sides of {_shape}"})
@Since(value={"1.0.0"})
public class ExprShapeSides
extends SimplePropertyExpression<PolyShape, Integer> {
    @Nullable
    public Integer convert(PolyShape polyShape) {
        return polyShape.getSides();
    }

    @Nullable
    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        Class[] classArray;
        switch (mode) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case SET: 
            case RESET: 
            case DELETE: 
            case ADD: 
            case REMOVE: {
                Class[] classArray2 = new Class[1];
                classArray = classArray2;
                classArray2[0] = Number.class;
                break;
            }
            case REMOVE_ALL: {
                classArray = new Class[]{};
            }
        }
        return classArray;
    }

    public void change(Event event, Object @Nullable [] delta, Changer.ChangeMode mode) {
        int change = delta != null ? ((Number)delta[0]).intValue() : 3;
        switch (mode) {
            case REMOVE: {
                change = -change;
            }
            case ADD: {
                for (PolyShape polyShape : (PolyShape[])this.getExpr().getArray(event)) {
                    polyShape.setSides(Math.max(3, polyShape.getSides() + change));
                }
                break;
            }
            case SET: 
            case RESET: 
            case DELETE: {
                change = Math.max(3, change);
                for (PolyShape polyShape : (PolyShape[])this.getExpr().getArray(event)) {
                    polyShape.setSides(change);
                }
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
    }

    public Class<? extends Integer> getReturnType() {
        return Integer.class;
    }

    protected String getPropertyName() {
        return "side count";
    }

    static {
        ExprShapeSides.register(ExprShapeSides.class, Integer.class, (String)"side(s| count)", (String)"polyshapes");
    }
}

