/*
 * Decompiled with CFR 0.152.
 */
package com.sovdee.skriptparticles.elements.expressions.properties;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.PropertyExpression;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import com.sovdee.skriptparticles.shapes.Shape;
import org.bukkit.event.Event;
import org.jetbrains.annotations.Nullable;

@Name(value="Shape Style")
@Description(value={"Returns the style of a shape. This determines how the shape is drawn. See the shape style type for more information.", "Changing this will change the style of the shape accordingly."})
@Examples(value={"set style of {_shape} to solid", "set {_shape}'s style to wireframe", "set style of {_shape} to hollow"})
@Since(value={"1.0.0"})
public class ExprShapeStyle
extends SimplePropertyExpression<Shape, Shape.Style> {
    @Nullable
    public Shape.Style convert(Shape shape) {
        return shape.getStyle();
    }

    @Nullable
    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        Class[] classArray;
        switch (mode) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case SET: {
                Class[] classArray2 = new Class[1];
                classArray = classArray2;
                classArray2[0] = Shape.Style.class;
                break;
            }
            case ADD: 
            case REMOVE: 
            case REMOVE_ALL: 
            case DELETE: 
            case RESET: {
                classArray = new Class[]{};
            }
        }
        return classArray;
    }

    public void change(Event event, Object @Nullable [] delta, Changer.ChangeMode mode) {
        if (delta == null || delta.length != 1) {
            return;
        }
        Shape.Style style = (Shape.Style)((Object)delta[0]);
        for (Shape shape : (Shape[])this.getExpr().getArray(event)) {
            shape.setStyle(style);
        }
    }

    public Class<? extends Shape.Style> getReturnType() {
        return Shape.Style.class;
    }

    protected String getPropertyName() {
        return "style of shape";
    }

    static {
        PropertyExpression.register(ExprShapeStyle.class, Shape.Style.class, (String)"style", (String)"shapes");
    }
}

