/*
 * Decompiled with CFR 0.152.
 */
package com.sovdee.skriptparticles.elements.expressions.properties;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import com.sovdee.skriptparticles.shapes.Shape;
import com.sovdee.skriptparticles.shapes.Star;
import org.bukkit.event.Event;
import org.jetbrains.annotations.Nullable;

@Name(value="Star Points")
@Description(value={"Returns the number of points on a star. This is the number of points on the star, not the number of particles drawn.", "Changing this will change the number of points on the star. The number of points must be at least 2."})
@Examples(value={"set {_shape}'s star points to 5", "set star points of {_shape} to 10", "set star points of {_shape} to 2 * (star points of {_shape})"})
@Since(value={"1.0.1"})
public class ExprStarPoints
extends SimplePropertyExpression<Shape, Number> {
    @Nullable
    public Number convert(Shape shape) {
        if (shape instanceof Star) {
            return ((Star)shape).getStarPoints();
        }
        return null;
    }

    @Nullable
    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        Class[] classArray;
        switch (mode) {
            case SET: 
            case ADD: 
            case REMOVE: {
                Class[] classArray2 = new Class[1];
                classArray = classArray2;
                classArray2[0] = Number.class;
                break;
            }
            default: {
                classArray = new Class[]{};
            }
        }
        return classArray;
    }

    public void change(Event event, Object @Nullable [] delta, Changer.ChangeMode mode) {
        if (delta == null || delta.length == 0) {
            return;
        }
        Shape[] shapes = (Shape[])this.getExpr().getArray(event);
        int deltaValue = ((Number)delta[0]).intValue();
        switch (mode) {
            case REMOVE: {
                deltaValue = -deltaValue;
            }
            case ADD: {
                for (Shape shape : shapes) {
                    if (!(shape instanceof Star)) continue;
                    Star star = (Star)shape;
                    star.setStarPoints(Math.max(star.getStarPoints() + deltaValue, 2));
                }
                break;
            }
            case SET: {
                deltaValue = Math.max(deltaValue, 2);
                for (Shape shape : shapes) {
                    if (!(shape instanceof Star)) continue;
                    Star star = (Star)shape;
                    star.setStarPoints(deltaValue);
                }
                break;
            }
        }
    }

    public Class<? extends Number> getReturnType() {
        return Number.class;
    }

    protected String getPropertyName() {
        return "star points";
    }

    static {
        ExprStarPoints.register(ExprStarPoints.class, Number.class, (String)"star points", (String)"shapes");
    }
}

