/*
 * Decompiled with CFR 0.152.
 */
package com.sovdee.skriptparticles.elements.expressions.properties;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.sovdee.skriptparticles.shapes.Shape;
import com.sovdee.skriptparticles.shapes.Star;
import org.bukkit.event.Event;
import org.jetbrains.annotations.Nullable;

@Name(value="Star Radii")
@Description(value={"Returns the inner or outer radius of a star. The inner radius is the distance from the center of the star to the innermost points, and likewise the outer radius is the distance to the tips of the star.", "Changing this will change the size of the star. Both radii must be greater than 0."})
@Examples(value={"set {_star} to a star with 5 points, inner radius 1, and outer radius 2", "set {_star}'s inner radius to 2", "set {_star}'s outer radius to 3"})
@Since(value={"1.0.1"})
public class ExprStarRadii
extends SimplePropertyExpression<Shape, Number> {
    private boolean isInner;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.isInner = parseResult.hasTag("inner");
        return super.init(exprs, matchedPattern, isDelayed, parseResult);
    }

    @Nullable
    public Number convert(Shape shape) {
        if (shape instanceof Star) {
            Star star = (Star)shape;
            return this.isInner ? star.getInnerRadius() : star.getOuterRadius();
        }
        return null;
    }

    @Nullable
    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        Class[] classArray;
        switch (mode) {
            case SET: 
            case ADD: 
            case REMOVE: {
                Class[] classArray2 = new Class[1];
                classArray = classArray2;
                classArray2[0] = Number.class;
                break;
            }
            default: {
                classArray = new Class[]{};
            }
        }
        return classArray;
    }

    public void change(Event event, Object @Nullable [] delta, Changer.ChangeMode mode) {
        if (delta == null || delta.length == 0) {
            return;
        }
        double deltaValue = ((Number)delta[0]).doubleValue();
        Shape[] shapes = (Shape[])this.getExpr().getArray(event);
        switch (mode) {
            case REMOVE: {
                deltaValue = -deltaValue;
            }
            case ADD: {
                for (Shape shape : shapes) {
                    if (!(shape instanceof Star)) continue;
                    Star star = (Star)shape;
                    if (this.isInner) {
                        star.setInnerRadius(Math.max(star.getInnerRadius() + deltaValue, 1.0E-4));
                        continue;
                    }
                    star.setOuterRadius(Math.max(star.getOuterRadius() + deltaValue, 1.0E-4));
                }
                break;
            }
            case SET: {
                deltaValue = Math.max(deltaValue, 1.0E-4);
                for (Shape shape : shapes) {
                    if (!(shape instanceof Star)) continue;
                    Star star = (Star)shape;
                    if (this.isInner) {
                        star.setInnerRadius(deltaValue);
                        continue;
                    }
                    star.setOuterRadius(deltaValue);
                }
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
    }

    public Class<? extends Number> getReturnType() {
        return Double.class;
    }

    protected String getPropertyName() {
        return (this.isInner ? "inner" : "outer") + " radius";
    }

    static {
        ExprStarRadii.register(ExprStarRadii.class, Number.class, (String)"(:inner|outer) radius", (String)"shapes");
    }
}

