/*
 * Decompiled with CFR 0.152.
 */
package com.sovdee.skriptparticles.elements.sections;

import ch.njol.skript.Skript;
import ch.njol.skript.config.SectionNode;
import ch.njol.skript.effects.Delay;
import ch.njol.skript.lang.EffectSection;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.Trigger;
import ch.njol.skript.lang.TriggerItem;
import ch.njol.skript.registrations.EventValues;
import ch.njol.skript.util.Direction;
import ch.njol.skript.util.Getter;
import ch.njol.skript.util.Timespan;
import ch.njol.skript.variables.Variables;
import ch.njol.util.Kleenean;
import com.sovdee.skriptparticles.SkriptParticle;
import com.sovdee.skriptparticles.shapes.Shape;
import com.sovdee.skriptparticles.util.DynamicLocation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.HandlerList;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public abstract class DrawShapeEffectSection
extends EffectSection {
    public static final Timespan ONE_TICK = new Timespan(Timespan.TimePeriod.TICK, 1L);
    protected Expression<Shape> shapes;
    protected @Nullable Expression<Direction> directions;
    protected @Nullable Expression<?> locations;
    protected @Nullable Expression<Player> players;
    private @Nullable Trigger trigger;
    protected boolean useShapeLocation;
    protected boolean sync;

    public boolean init(Expression<?>[] expressions, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult, @Nullable SectionNode sectionNode, @Nullable List<TriggerItem> list) {
        if (this.hasSection()) {
            AtomicBoolean delayed = new AtomicBoolean(false);
            Runnable afterLoading = () -> delayed.set(!this.getParser().getHasDelayBefore().isFalse());
            assert (sectionNode != null);
            this.trigger = this.loadCode(sectionNode, "draw", afterLoading, new Class[]{DrawEvent.class});
            if (delayed.get()) {
                Skript.error((String)"Delays can't be used within a Draw Shape Effect Section");
                return false;
            }
        }
        return this.init(expressions, matchedPattern, isDelayed, parseResult, this.hasSection());
    }

    public boolean init(@Nullable Expression<?>[] expressions, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult, boolean hasSection) {
        this.shapes = expressions[0];
        if (expressions[2] != null) {
            if (expressions[1] != null) {
                this.directions = expressions[1];
            }
            this.locations = expressions[2];
        } else {
            this.useShapeLocation = true;
        }
        this.players = expressions[3];
        this.sync = parseResult.hasTag("sync");
        return true;
    }

    protected @Nullable TriggerItem walk(Event event) {
        this.debug(event, true);
        Delay.addDelayedEvent((Event)event);
        ArrayList<Player> recipients = new ArrayList<Player>();
        if (this.players != null) {
            recipients.addAll(List.of((Player[])this.players.getArray(event)));
        } else {
            recipients.addAll(Bukkit.getOnlinePlayers());
        }
        @Nullable Object localVars = Variables.copyLocalVariables((Event)event);
        Consumer<Shape> consumer = this.trigger != null ? shape -> {
            DrawEvent drawEvent = new DrawEvent((Shape)shape);
            Variables.setLocalVariables((Event)drawEvent, (Object)localVars);
            TriggerItem.walk((TriggerItem)this.trigger, (Event)drawEvent);
            Variables.setLocalVariables((Event)event, (Object)Variables.copyLocalVariables((Event)drawEvent));
            Variables.removeLocals((Event)drawEvent);
        } : null;
        ArrayList<DynamicLocation> locations = new ArrayList<DynamicLocation>();
        Direction direction = null;
        if (!this.useShapeLocation) {
            if (this.directions != null) {
                direction = (Direction)this.directions.getSingle(event);
            }
            assert (this.locations != null);
            for (Object location : this.locations.getArray(event)) {
                if (location instanceof Entity) {
                    locations.add(new DynamicLocation((Entity)location, direction));
                    continue;
                }
                if (!(location instanceof Location)) continue;
                locations.add(new DynamicLocation((Location)location, direction));
            }
        } else {
            locations.add(new DynamicLocation());
        }
        if (this.sync) {
            this.executeSync(event, locations, consumer, recipients);
        } else {
            ArrayList<Shape> preppedShapes = new ArrayList<Shape>();
            for (Shape shape2 : (Shape[])this.shapes.getArray(event)) {
                Shape preppedShape = shape2.clone();
                if (consumer != null) {
                    consumer.accept(preppedShape);
                }
                preppedShapes.add(preppedShape);
            }
            if (preppedShapes.isEmpty()) {
                return this.getNext();
            }
            this.setupAsync(event, locations, preppedShapes, recipients);
        }
        return this.getNext();
    }

    protected void setupAsync(Event event, final Collection<DynamicLocation> locations, final Collection<Shape> shapes, final Collection<Player> recipients) {
        BukkitRunnable runnable = new BukkitRunnable(){

            public void run() {
                DrawShapeEffectSection.this.executeAsync(locations, shapes, recipients);
            }
        };
        runnable.runTaskAsynchronously((Plugin)Skript.getInstance());
    }

    protected void executeSync(Event event, Collection<DynamicLocation> locations, @Nullable Consumer<Shape> consumer, Collection<Player> recipients) {
        block5: {
            try {
                for (DynamicLocation dynamicLocation : locations) {
                    for (Shape shape : (Shape[])this.shapes.getArray(event)) {
                        if (consumer != null) {
                            Shape shapeCopy = shape.clone();
                            shapeCopy.draw(dynamicLocation, consumer, recipients);
                            continue;
                        }
                        shape.draw(dynamicLocation, recipients);
                    }
                }
            }
            catch (IllegalArgumentException exception) {
                SkriptParticle.severe("Unable to draw shape[s]! Please check that your particles are valid!");
                SkriptParticle.severe("Exception: " + exception.getMessage());
                SkriptParticle.severe("To see the full stack trace, set Skript's verbosity to very high or debug.");
                if (!Skript.logVeryHigh()) break block5;
                exception.printStackTrace();
            }
        }
    }

    protected void executeAsync(Collection<DynamicLocation> locations, Collection<Shape> shapes, Collection<Player> recipients) {
        block4: {
            try {
                for (DynamicLocation dynamicLocation : locations) {
                    for (Shape shape : shapes) {
                        shape.draw(dynamicLocation, recipients);
                    }
                }
            }
            catch (IllegalArgumentException exception) {
                SkriptParticle.severe("Unable to draw shape[s]! Please check that your particles are valid!");
                SkriptParticle.severe("Exception: " + exception.getMessage());
                SkriptParticle.severe("To see the full stack trace, set Skript's verbosity to very high or debug.");
                if (!Skript.logVeryHigh()) break block4;
                exception.printStackTrace();
            }
        }
    }

    static {
        EventValues.registerEventValue(DrawEvent.class, Shape.class, (Getter)new Getter<Shape, DrawEvent>(){

            public Shape get(DrawEvent drawEvent) {
                return drawEvent.getShape();
            }
        }, (int)0);
    }

    public static class DrawEvent
    extends Event {
        private final Shape shape;

        public DrawEvent(Shape shape) {
            this.shape = shape;
        }

        public Shape getShape() {
            return this.shape;
        }

        public @NonNull HandlerList getHandlers() {
            throw new IllegalStateException();
        }
    }
}

