/*
 * Decompiled with CFR 0.152.
 */
package com.sovdee.skriptparticles.elements.sections;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.util.Timespan;
import ch.njol.util.Kleenean;
import com.sovdee.skriptparticles.elements.sections.DrawShapeEffectSection;
import com.sovdee.skriptparticles.shapes.Shape;
import com.sovdee.skriptparticles.util.DynamicLocation;
import java.util.Collection;
import java.util.function.Consumer;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

@Name(value="Draw Shape Animation")
@Description(value={})
@Examples(value={})
@Since(value={"1.2.0"})
public class EffSecDrawShapeAnimation
extends DrawShapeEffectSection {
    private Expression<Timespan> duration;

    @Override
    public boolean init(@Nullable Expression<?>[] expressions, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult, boolean hasSection) {
        this.duration = expressions[4];
        return super.init(expressions, matchedPattern, isDelayed, parseResult, hasSection);
    }

    @Override
    protected void executeSync(Event event, Collection<DynamicLocation> locations, @Nullable Consumer<Shape> consumer, Collection<Player> recipients) {
    }

    @Override
    protected void setupAsync(Event event, Collection<DynamicLocation> locations, Collection<Shape> shapes, Collection<Player> recipients) {
        Timespan duration = this.duration.getOptionalSingle(event).orElse(new Timespan(Timespan.TimePeriod.TICK, 0L));
        long milliseconds = duration.getAs(Timespan.TimePeriod.MILLISECOND);
        for (Shape shape : shapes) {
            shape.setAnimationDuration(milliseconds);
        }
        super.setupAsync(event, locations, shapes, recipients);
    }

    public @NonNull String toString(@Nullable Event event, boolean debug) {
        return "draw an animation of the shape of " + this.shapes.toString(event, debug) + " at " + (this.locations != null ? this.locations.toString(event, debug) : "shape's location") + " for " + (String)(this.players == null ? "all players" : this.players.toString(event, debug) + " over " + this.duration.toString(event, debug));
    }

    static {
        Skript.registerSection(EffSecDrawShapeAnimation.class, (String[])new String[]{"draw [an] (animation [of] [the]|animated) shape[s] [of] %shapes% [%-directions% %-locations/entities%] [to %-players%] over %timespan%"});
    }
}

