/*
 * Decompiled with CFR 0.152.
 */
package com.sovdee.skriptparticles.elements.sections;

import ch.njol.skript.Skript;
import ch.njol.skript.config.SectionNode;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.Section;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.TriggerItem;
import ch.njol.skript.lang.util.SimpleLiteral;
import ch.njol.skript.util.LiteralUtils;
import ch.njol.util.Kleenean;
import com.sovdee.skriptparticles.particles.Particle;
import com.sovdee.skriptparticles.particles.ParticleMotion;
import com.sovdee.skriptparticles.util.ParticleUtil;
import java.util.List;
import org.bukkit.event.Event;
import org.bukkit.util.Vector;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.skriptlang.skript.lang.entry.EntryContainer;
import org.skriptlang.skript.lang.entry.EntryData;
import org.skriptlang.skript.lang.entry.EntryValidator;
import org.skriptlang.skript.lang.entry.util.ExpressionEntryData;

@Name(value="Custom Particle Section")
@Description(value={"This section can be used in conjunction with the `last created particle` expression to create custom particles.", "The particle can be any custom particle from skript-particle or from skbee.", "Fields include:", "\tcount: integer - the number of particles to create (required)", "\toffset: vector - the offset value of the particle. See the Minecraft wiki on /particle for more info. (default: 0, 0, 0)", "\tvelocity: vector - the velocity of the particle. Can be a vector or a motion (inwards/clockwise/etc.). (default: 0, 0, 0)", "\textra: number - the extra value of the particle. Forces `count` to be 0 and cannot be combined with `offset`. See the Minecraft wiki on /particle for more info. (default: 0)", "\tdata: object - the data value of the particle. For example, `dustOptions()` for the dust particle. See the Minecraft wiki on /particle for more info. (default: null)", "\tforce: boolean - whether or not to force the particle to be seen at long range. (default: false)"})
@Examples(value={"create a new custom electric spark particle with:", "\tcount: 10", "\toffset: vector(1, 1, 1)", "\textra: 0.2", "\tforce: true", "set {_particle} to last created particle", "", "create a new custom dust particle with:", "\tcount: 0", "\tvelocity: inwards", "\textra: 0.5", "\tforce: true", "\tdata: dustOption(red, 5)", "set {_particle} to last created particle"})
@Since(value={"1.0.2"})
public class SecParticle
extends Section {
    public static @Nullable Particle lastCreatedParticle;
    private static final EntryValidator validator;
    private Expression<org.bukkit.Particle> particle;
    private @Nullable Expression<Number> count;
    private @Nullable Expression<Vector> offset;
    private @Nullable Expression<?> velocity;
    private @Nullable Expression<Number> extra;
    private @Nullable Expression<Object> data;
    private @Nullable Expression<Boolean> force;

    public boolean init(Expression<?>[] expressions, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult, SectionNode sectionNode, List<TriggerItem> triggerItems) {
        @Nullable EntryContainer entryContainer = validator.validate(sectionNode);
        if (entryContainer == null) {
            return false;
        }
        this.particle = expressions[0];
        this.count = (Expression)entryContainer.getOptional("count", Expression.class, true);
        this.offset = (Expression)entryContainer.getOptional("offset", Expression.class, true);
        this.extra = (Expression)entryContainer.getOptional("extra", Expression.class, true);
        this.force = (Expression)entryContainer.getOptional("force", Expression.class, true);
        this.velocity = (Expression)entryContainer.getOptional("velocity", Expression.class, true);
        if (this.velocity != null) {
            this.velocity = LiteralUtils.defendExpression(this.velocity);
            if (!LiteralUtils.canInitSafely((Expression[])new Expression[]{this.velocity})) {
                Skript.error((String)"Invalid expression for velocity! Must be a vector or a particle motion.");
                return false;
            }
        }
        this.data = (Expression)entryContainer.getOptional("data", Expression.class, true);
        if (this.data != null) {
            this.data = LiteralUtils.defendExpression(this.data);
            if (!LiteralUtils.canInitSafely((Expression[])new Expression[]{this.data})) {
                Skript.error((String)"Invalid value for data! Must be a dust options, item, or other particle data!");
                return false;
            }
        }
        if (this.offset != null && this.velocity != null) {
            Skript.error((String)"You cannot have both an offset and a velocity for a particle!");
            return false;
        }
        return true;
    }

    protected @Nullable TriggerItem walk(Event event) {
        this.execute(event);
        return this.walk(event, false);
    }

    private void execute(Event event) {
        @Nullable org.bukkit.Particle bukkitParticle = (org.bukkit.Particle)this.particle.getSingle(event);
        if (bukkitParticle == null) {
            return;
        }
        @Nullable Number count = (Number)this.count.getSingle(event);
        if (count == null) {
            return;
        }
        Vector offset = this.offset != null ? (Vector)this.offset.getSingle(event) : null;
        Number extra = this.extra != null ? (Number)((Number)this.extra.getSingle(event)) : (Number)null;
        Object data = this.data != null ? this.data.getSingle(event) : null;
        Boolean force = this.force != null ? (Boolean)this.force.getSingle(event) : null;
        Particle particle = (Particle)new Particle(bukkitParticle).count(count.intValue());
        if (this.velocity != null) {
            @Nullable Object v = this.velocity.getSingle(event);
            if (v instanceof ParticleMotion) {
                ParticleMotion motion = (ParticleMotion)((Object)v);
                particle.motion(motion);
            } else if (v instanceof Vector) {
                Vector vector = (Vector)v;
                particle.count(0).offset(vector.getX(), vector.getY(), vector.getZ());
            }
        }
        if (offset != null) {
            particle.offset(offset.getX(), offset.getY(), offset.getZ());
        }
        if (extra != null) {
            particle.extra(extra.doubleValue());
        }
        if (data != null && (data = ParticleUtil.getData(particle.particle(), data)) != null) {
            particle.data(data);
        }
        if (force != null) {
            particle.force(force);
        }
        lastCreatedParticle = particle;
    }

    public String toString(@Nullable Event event, boolean debug) {
        return "new custom particle from " + this.particle.toString(event, debug);
    }

    static {
        validator = EntryValidator.builder().addEntryData((EntryData)new ExpressionEntryData("count", (Expression)new SimpleLiteral((Object)1, false), false, Number.class)).addEntryData((EntryData)new ExpressionEntryData("offset", null, true, Vector.class)).addEntryData((EntryData)new ExpressionEntryData("velocity", null, true, Object.class)).addEntryData((EntryData)new ExpressionEntryData("extra", null, true, Number.class)).addEntryData((EntryData)new ExpressionEntryData("data", null, true, Object.class)).addEntryData((EntryData)new ExpressionEntryData("force", null, true, Boolean.class)).build();
        Skript.registerSection(SecParticle.class, (String[])new String[]{"create [a] [new] custom %particle% [particle] [with]"});
    }
}

