/*
 * Decompiled with CFR 0.152.
 */
package com.sovdee.skriptparticles.elements.types;

import ch.njol.skript.classes.ClassInfo;
import ch.njol.skript.classes.EnumClassInfo;
import ch.njol.skript.classes.Parser;
import ch.njol.skript.lang.ParseContext;
import ch.njol.skript.lang.function.Functions;
import ch.njol.skript.lang.function.JavaFunction;
import ch.njol.skript.lang.function.Parameter;
import ch.njol.skript.lang.function.SimpleJavaFunction;
import ch.njol.skript.registrations.Classes;
import ch.njol.skript.registrations.DefaultClasses;
import ch.njol.skript.util.Color;
import ch.njol.skript.util.Timespan;
import com.destroystokyo.paper.ParticleBuilder;
import com.sovdee.skriptparticles.particles.Particle;
import com.sovdee.skriptparticles.particles.ParticleMotion;
import com.sovdee.skriptparticles.util.ParticleUtil;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.Vibration;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.jetbrains.annotations.Nullable;
import org.skriptlang.skript.lang.converter.Converters;

public class ParticleTypes {
    static {
        if (Classes.getExactClassInfo(org.bukkit.Particle.class) == null) {
            Classes.registerClass((ClassInfo)new ClassInfo(org.bukkit.Particle.class, "particle").user(new String[]{"particles?"}).name("Particle").description(new String[]{"A mirror of SkBee's Particle type. For use when SkBee is not installed.", "Represents a particle which can be used as a shape's particle, or in the Draw Particle and Particle Spawn effects.", "Some particles require extra data, these are distinguished by their data type within the square brackets.", "DustOption, DustTransition and Vibration each have their own functions to build the appropriate data for these particles."}).usage(new String[]{ParticleUtil.getNamesAsString()}).examples(new String[]{"draw 1 of soul at location of player", "draw 10 of dust using dustOption(green, 10) at location of player", "draw 3 of item using player's tool at location of player", "draw 1 of block using dirt at location of player", "draw 1 of dust_color_transition using dustTransition(blue, green, 3) at location of player", "draw 1 of vibration using vibration({loc1}, {loc2}, 1 second) at {loc1}"}).since("1.0.0").parser((Parser)new Parser<org.bukkit.Particle>(){

                @Nullable
                public org.bukkit.Particle parse(String s, ParseContext context) {
                    return ParticleUtil.parse(s.replace(" ", "_"));
                }

                public @NonNull String toString(org.bukkit.Particle particle, int flags) {
                    return ParticleUtil.getName(particle);
                }

                public @NonNull String toVariableNameString(org.bukkit.Particle particle) {
                    return "particle:" + this.toString(particle, 0);
                }
            }));
        }
        Classes.registerClass((ClassInfo)new ClassInfo(Particle.class, "customparticle").user(new String[]{"customparticles?"}).name("Custom Particle").description(new String[]{"Represents a particle with extra data, including offset, count, data, and more."}).parser((Parser)new Parser<Particle>(){

            @Nullable
            public Particle parse(String s, ParseContext context) {
                return null;
            }

            public boolean canParse(ParseContext context) {
                return false;
            }

            public @NonNull String toString(Particle particle, int flags) {
                return ParticleUtil.getName(particle.particle());
            }

            public @NonNull String toVariableNameString(Particle particle) {
                return "particle:" + this.toString(particle, 0);
            }
        }));
        Classes.registerClass((ClassInfo)new EnumClassInfo(ParticleMotion.class, "particlemotion", "particle motions").user(new String[]{"particle ?motions?"}).name("Particle Motion").description(new String[]{"Represents the motion of a particle relative to a shape."}));
        Converters.registerConverter(org.bukkit.Particle.class, Particle.class, particle -> (Particle)new Particle((org.bukkit.Particle)particle).count(1).extra(0.0));
        Converters.registerConverter(Particle.class, org.bukkit.Particle.class, ParticleBuilder::particle);
        if (Classes.getExactClassInfo(Particle.DustOptions.class) == null) {
            Classes.registerClass((ClassInfo)new ClassInfo(Particle.DustOptions.class, "dustoption").name(ClassInfo.NO_DOC).user(new String[]{"dust ?options?"}));
            Functions.registerFunction((JavaFunction)new SimpleJavaFunction<Particle.DustOptions>("dustOption", new Parameter[]{new Parameter("color", DefaultClasses.COLOR, true, null), new Parameter("size", DefaultClasses.NUMBER, true, null)}, Classes.getExactClassInfo(Particle.DustOptions.class), true){

                public Particle.DustOptions[] executeSimple(Object[][] params) {
                    org.bukkit.Color color = ((Color)params[0][0]).asBukkitColor();
                    float size = ((Number)params[1][0]).floatValue();
                    return new Particle.DustOptions[]{new Particle.DustOptions(color, size)};
                }
            }.description(new String[]{"A mirror of SkBee's dustOption function. For use when SkBee is not installed.\nCreates a new dust option to be used with 'dust' particle. Color can either be a regular color or an RGB color using", "Skript's rgb() function. Size is the size the particle will be."}).examples(new String[]{"set {_c} to dustOption(red, 1.5)", "set {_c} to dustOption(rgb(1, 255, 1), 3)"}).since("1.0.0"));
        }
        if (Classes.getExactClassInfo(Particle.DustTransition.class) == null) {
            Classes.registerClass((ClassInfo)new ClassInfo(Particle.DustTransition.class, "dusttransition").name(ClassInfo.NO_DOC).user(new String[]{"dust ?transitions?"}));
            Functions.registerFunction((JavaFunction)new SimpleJavaFunction<Particle.DustTransition>("dustTransition", new Parameter[]{new Parameter("fromColor", DefaultClasses.COLOR, true, null), new Parameter("toColor", DefaultClasses.COLOR, true, null), new Parameter("size", DefaultClasses.NUMBER, true, null)}, Classes.getExactClassInfo(Particle.DustTransition.class), true){

                public Particle.DustTransition[] executeSimple(Object[][] params) {
                    org.bukkit.Color fromColor = ((Color)params[0][0]).asBukkitColor();
                    org.bukkit.Color toColor = ((Color)params[1][0]).asBukkitColor();
                    float size = ((Number)params[2][0]).floatValue();
                    return new Particle.DustTransition[]{new Particle.DustTransition(fromColor, toColor, size)};
                }
            }.description(new String[]{"A mirror of SkBee's dustTransition function. For use when SkBee is not installed.\nCreates a new dust transition to be used with 'dust_color_transition' particle.", "Color can either be a regular color or an RGB color using Skript's rgb() function.", "Size is the size the particle will be. Requires MC 1.17+"}).examples(new String[]{"set {_d} to dustTransition(red, green, 10)", "set {_d} to dustTransition(blue, rgb(1,1,1), 5)"}).since("1.0.0"));
        }
        if (Classes.getExactClassInfo(Vibration.class) == null) {
            Classes.registerClass((ClassInfo)new ClassInfo(Vibration.class, "vibration").name(ClassInfo.NO_DOC).user(new String[]{"vibrations?"}));
            Functions.registerFunction((JavaFunction)new SimpleJavaFunction<Vibration>("vibration", new Parameter[]{new Parameter("to", DefaultClasses.LOCATION, true, null), new Parameter("arrivalTime", DefaultClasses.TIMESPAN, true, null)}, Classes.getExactClassInfo(Vibration.class), true){

                public Vibration[] executeSimple(Object[][] params) {
                    if (params[0].length == 0 || params[1].length == 0) {
                        return new Vibration[0];
                    }
                    Location destination = (Location)params[0][0];
                    int arrivalTime = (int)((Timespan)params[1][0]).getAs(Timespan.TimePeriod.TICK);
                    Vibration vibration = new Vibration((Vibration.Destination)new Vibration.Destination.BlockDestination(destination), arrivalTime);
                    return new Vibration[]{vibration};
                }
            }.description(new String[]{"A mirror of SkBee's Vibration function. For use when SkBee is not installed.\nCreates a new vibration to be used with 'vibration' particle.", "TO = the destination location the particle will travel to.", "ARRIVAL TIME = the time it will take to arrive at the destination location. Requires MC 1.17+"}).examples(new String[]{"set {_v} to vibration({loc1}, 10 seconds)"}).since("1.0.0"));
        }
    }
}

