/*
 * Decompiled with CFR 0.152.
 */
package com.sovdee.skriptparticles.elements.types;

import ch.njol.skript.classes.ClassInfo;
import ch.njol.skript.classes.Parser;
import ch.njol.skript.lang.ParseContext;
import ch.njol.skript.registrations.Classes;
import com.sovdee.skriptparticles.shapes.CutoffShape;
import com.sovdee.skriptparticles.shapes.LWHShape;
import com.sovdee.skriptparticles.shapes.PolyShape;
import com.sovdee.skriptparticles.shapes.RadialShape;
import com.sovdee.skriptparticles.shapes.Shape;
import org.jetbrains.annotations.Nullable;

public class ShapeTypes {
    static {
        Classes.registerClass((ClassInfo)new ClassInfo(Shape.class, "shape").user(new String[]{"shapes?"}).name("Shape").description(new String[]{"Represents an abstract particle shape. E.g. circle, line, etc."}).parser((Parser)new Parser<Shape>(){

            public Shape parse(String input, ParseContext context) {
                return null;
            }

            public boolean canParse(ParseContext context) {
                return false;
            }

            public String toString(Shape o, int flags) {
                return o.toString();
            }

            public String toVariableNameString(Shape shape) {
                return "shape:" + shape.getUUID();
            }
        }).cloner(Shape::clone));
        Classes.registerClass((ClassInfo)new ClassInfo(RadialShape.class, "radialshape").user(new String[]{"radial ?shapes?"}).name("Radial Shape").description(new String[]{"Represents an abstract particle shape that has a radius. E.g. circle, sphere, etc."}).parser((Parser)new Parser<RadialShape>(){

            public RadialShape parse(String input, ParseContext context) {
                return null;
            }

            public boolean canParse(ParseContext context) {
                return false;
            }

            public String toString(RadialShape o, int flags) {
                return o.toString();
            }

            public String toVariableNameString(RadialShape shape) {
                return "shape:" + shape.getUUID();
            }
        }));
        Classes.registerClass((ClassInfo)new ClassInfo(LWHShape.class, "lwhshape").user(new String[]{"lwh ?shapes?"}).name("Length/Width/Height Shape").description(new String[]{"Represents an abstract particle shape that has a length, width, and/or height. E.g. cube, cylinder, ellipse, etc."}).parser((Parser)new Parser<LWHShape>(){

            public LWHShape parse(String input, ParseContext context) {
                return null;
            }

            public boolean canParse(ParseContext context) {
                return false;
            }

            public String toString(LWHShape o, int flags) {
                return o.toString();
            }

            public String toVariableNameString(LWHShape shape) {
                return "shape:" + shape.getUUID();
            }
        }));
        Classes.registerClass((ClassInfo)new ClassInfo(CutoffShape.class, "cutoffshape").user(new String[]{"cutoff ?shapes?"}).name("Cutoff Shape").description(new String[]{"Represents an abstract particle shape that has a cutoff angle. E.g. arc, spherical cap, etc."}).parser((Parser)new Parser<CutoffShape>(){

            public CutoffShape parse(String input, ParseContext context) {
                return null;
            }

            public boolean canParse(ParseContext context) {
                return false;
            }

            public String toString(CutoffShape o, int flags) {
                return o.toString();
            }

            public String toVariableNameString(CutoffShape shape) {
                return "shape:" + shape.getUUID();
            }
        }));
        Classes.registerClass((ClassInfo)new ClassInfo(PolyShape.class, "polyshape").user(new String[]{"poly ?shapes?"}).name("Polygonal/Polyhedral Shape").description(new String[]{"Represents an abstract particle shape that is a polygon or polyhedron, with a side length and side count.\nIrregular shapes are included in this category, but do not support changing either side count or side length."}).parser((Parser)new Parser<PolyShape>(){

            public PolyShape parse(String input, ParseContext context) {
                return null;
            }

            public boolean canParse(ParseContext context) {
                return false;
            }

            public String toString(PolyShape o, int flags) {
                return o.toString();
            }

            public String toVariableNameString(PolyShape shape) {
                return "shape:" + shape.getUUID();
            }
        }));
        Classes.registerClass((ClassInfo)new ClassInfo(Shape.Style.class, "shapestyle").user(new String[]{"shape ?styles?"}).name("Shape Style").description(new String[]{"Represents the way the shape is drawn. Outlined is a wireframe representation, Surface is filling in all the surfaces of the shape, and Filled is filling in the entire shape."}).parser((Parser)new Parser<Shape.Style>(){

            @Nullable
            public Shape.Style parse(String s, ParseContext context) {
                if ((s = s.toUpperCase()).matches("OUTLINE(D)?") || s.matches("WIREFRAME")) {
                    return Shape.Style.OUTLINE;
                }
                if (s.matches("SURFACE") || s.matches("HOLLOW")) {
                    return Shape.Style.SURFACE;
                }
                if (s.matches("FILL(ED)?") || s.matches("SOLID")) {
                    return Shape.Style.FILL;
                }
                return null;
            }

            public boolean canParse(ParseContext context) {
                return true;
            }

            public String toString(Shape.Style style, int i) {
                return style.toString();
            }

            public String toVariableNameString(Shape.Style style) {
                return "shapestyle:" + style;
            }
        }));
    }
}

