/*
 * Decompiled with CFR 0.152.
 */
package com.sovdee.skriptparticles.particles;

import com.destroystokyo.paper.ParticleBuilder;
import com.sovdee.skriptparticles.particles.ParticleGradient;
import com.sovdee.skriptparticles.particles.ParticleMotion;
import com.sovdee.skriptparticles.shapes.Shape;
import org.bukkit.Location;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nullable;

public class Particle
extends ParticleBuilder {
    @Nullable
    private ParticleMotion motion;
    @Nullable
    private ParticleGradient gradient;
    @Nullable
    private Shape parent;
    private boolean override = false;

    public Particle(org.bukkit.Particle particle) {
        super(particle);
    }

    public Particle(org.bukkit.Particle particle, ParticleMotion motion) {
        super(particle);
        this.motion = motion;
    }

    public void spawn(Vector delta) {
        if (this.parent == null || this.parent.getLastLocation() == null) {
            return;
        }
        if (this.motion != null) {
            Vector motionVector = this.motion.getMotionVector(this.parent.getRelativeYAxis(true), delta);
            this.offset(motionVector.getX(), motionVector.getY(), motionVector.getZ());
            this.count(0);
        }
        if (this.gradient != null) {
            this.color(this.gradient.calculateColour(delta));
        }
        this.location(this.parent.getLastLocation().getLocation().add(delta));
        super.spawn();
    }

    @Nullable
    public ParticleMotion motion() {
        return this.motion;
    }

    public Particle motion(@Nullable ParticleMotion motion) {
        this.motion = motion;
        return this;
    }

    @Nullable
    public Shape parent() {
        return this.parent;
    }

    public Particle parent(@Nullable Shape parent) {
        this.parent = parent;
        return this;
    }

    @Nullable
    public ParticleGradient gradient() {
        return this.gradient;
    }

    public Particle gradient(@Nullable ParticleGradient gradient) {
        this.gradient = gradient;
        return this;
    }

    public boolean override() {
        return this.override;
    }

    public Particle override(boolean override) {
        this.override = override;
        return this;
    }

    @Contract(value="-> new")
    public Particle clone() {
        Particle particle = (Particle)new Particle(this.particle()).count(this.count()).extra(this.extra()).offset(this.offsetX(), this.offsetY(), this.offsetZ()).data(this.data()).force(this.force()).receivers(this.receivers()).source(this.source());
        @Nullable Location location = this.location();
        if (location != null) {
            particle.location(location);
        }
        return particle.motion(this.motion()).parent(this.parent()).gradient(this.gradient()).override(this.override());
    }

    public String toString() {
        return "Particle{particle=" + this.particle() + (String)(this.motion != null ? ", motion=" + this.motion : "") + (String)(this.gradient != null ? ", gradient=" + this.gradient : "") + (String)(this.parent != null ? ", parent=" + this.parent : "") + ", override=" + this.override + "}";
    }
}

