/*
 * Decompiled with CFR 0.152.
 */
package com.sovdee.skriptparticles.particles;

import ch.njol.skript.util.ColorRGB;
import com.sovdee.skriptparticles.util.Quaternion;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Color;
import org.bukkit.util.Vector;
import org.joml.Quaternionfc;

public class ParticleGradient {
    private final Quaternion orientation = new Quaternion(1.0f, 0.0f, 0.0f, 0.0f);
    private final List<Point> points = new ArrayList<Point>();
    private boolean local = false;

    public Color calculateColour(Vector delta) {
        if (this.local) {
            this.orientation.transform(delta);
        }
        double weightTotal = 0.0;
        double[] rgb = new double[]{0.0, 0.0, 0.0};
        for (Point point : this.points) {
            double weight = 1.0 / point.getPosition().clone().subtract(delta).length();
            weightTotal += weight;
            Color colour = point.getColor();
            rgb[0] = rgb[0] + weight * (double)colour.getRed();
            rgb[1] = rgb[1] + weight * (double)colour.getGreen();
            rgb[2] = rgb[2] + weight * (double)colour.getBlue();
        }
        return Color.fromRGB((int)((int)(rgb[0] / weightTotal)), (int)((int)(rgb[1] / weightTotal)), (int)((int)(rgb[2] / weightTotal)));
    }

    public Quaternion getOrientation() {
        return this.orientation;
    }

    public void setOrientation(Quaternion orientation) {
        this.orientation.set((Quaternionfc)orientation.clone());
    }

    public List<Point> getPoints() {
        return this.points;
    }

    public void setPoints(List<Point> points) {
        this.points.clear();
        this.points.addAll(points);
    }

    public void addPoint(Vector position, Color color) {
        this.points.add(new Point(position, color));
    }

    public boolean isLocal() {
        return this.local;
    }

    public void setLocal(boolean local) {
        this.local = local;
    }

    public String toString() {
        return "ParticleGradient{orientation=" + this.orientation + ", points=" + this.points + ", local=" + this.local + "}";
    }

    public static class Point {
        private Vector position;
        private Color color;

        public Point(Vector position, Color color) {
            this.position = position;
            this.color = color;
        }

        public Point(Vector position, ColorRGB color) {
            this.position = position;
            this.color = color.asBukkitColor();
        }

        public Vector getPosition() {
            return this.position;
        }

        public void setPosition(Vector position) {
            this.position = position;
        }

        public Color getColor() {
            return this.color;
        }

        public void setColor(Color color) {
            this.color = color;
        }

        public String toString() {
            return "Point{position=" + this.position + ", color=" + this.color + "}";
        }
    }
}

