/*
 * Decompiled with CFR 0.152.
 */
package com.sovdee.skriptparticles.particles;

import org.bukkit.util.Vector;

public enum ParticleMotion {
    CLOCKWISE,
    COUNTERCLOCKWISE,
    INWARDS,
    OUTWARDS,
    NONE;

    private static final Vector DEFAULT_MOTION;

    public Vector getMotionVector(Vector axis, Vector point) {
        return switch (this) {
            default -> throw new IncompatibleClassChangeError();
            case NONE -> DEFAULT_MOTION.clone();
            case CLOCKWISE -> this.getAntiClockwiseMotion(axis, point).multiply(-1);
            case COUNTERCLOCKWISE -> this.getAntiClockwiseMotion(axis, point);
            case INWARDS -> this.getOutwardsMotion(point).multiply(-1);
            case OUTWARDS -> this.getOutwardsMotion(point);
        };
    }

    private Vector getAntiClockwiseMotion(Vector axis, Vector point) {
        return axis.getCrossProduct(point).normalize();
    }

    private Vector getOutwardsMotion(Vector point) {
        return point.clone().normalize();
    }

    static {
        DEFAULT_MOTION = new Vector(0, 0, 0);
    }
}

