/*
 * Decompiled with CFR 0.152.
 */
package com.sovdee.skriptparticles.shapes;

import ch.njol.skript.Skript;
import com.sovdee.skriptparticles.particles.Particle;
import com.sovdee.skriptparticles.particles.ParticleGradient;
import com.sovdee.skriptparticles.shapes.Shape;
import com.sovdee.skriptparticles.util.DynamicLocation;
import com.sovdee.skriptparticles.util.MathUtil;
import com.sovdee.skriptparticles.util.ParticleUtil;
import com.sovdee.skriptparticles.util.Quaternion;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;
import java.util.function.Consumer;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.jetbrains.annotations.Contract;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;

public abstract class AbstractShape
implements Shape {
    private final UUID uuid;
    private Set<Vector> points;
    private Shape.Style style = Shape.Style.OUTLINE;
    private final Quaternion orientation;
    private final Quaternion lastOrientation;
    private double scale = 1.0;
    private Vector offset;
    private @Nullable DynamicLocation location;
    private Particle particle;
    private @Nullable Comparator<Vector> ordering;
    private double particleDensity = 0.25;
    private long animationDuration = 0L;
    private Shape.State lastState;
    private @Nullable DynamicLocation lastLocation;
    private boolean needsUpdate = false;
    private boolean drawLocalAxes = false;
    private boolean drawGlobalAxes = false;

    public AbstractShape() {
        this.points = new LinkedHashSet<Vector>();
        this.orientation = Quaternion.IDENTITY.clone();
        this.lastOrientation = Quaternion.IDENTITY.clone();
        this.offset = new Vector(0, 0, 0);
        this.particle = (Particle)new Particle(org.bukkit.Particle.FLAME).parent(this).extra(0.0);
        this.uuid = UUID.randomUUID();
        this.lastState = this.getState();
    }

    @Override
    public Set<Vector> getPoints() {
        return this.getPoints(this.orientation);
    }

    @Override
    public Set<Vector> getPoints(Quaternion orientation) {
        Shape.State state = this.getState(orientation);
        if (this.needsUpdate || !this.lastState.equals(state) || this.points.isEmpty()) {
            this.points = this.ordering != null ? new TreeSet<Vector>(this.ordering) : new LinkedHashSet<Vector>();
            this.generatePoints(this.points);
            for (Vector point : this.points) {
                orientation.transform(point);
                point.multiply(this.scale);
                point.add(this.offset);
            }
            this.lastState = state;
            this.needsUpdate = false;
        }
        return this.points;
    }

    @Override
    public void setPoints(Set<Vector> points) {
        this.points = points;
    }

    @Override
    @Contract(pure=true)
    public void generateSurface(Set<Vector> points) {
        this.generateOutline(points);
    }

    @Override
    @Contract(pure=true)
    public void generateFilled(Set<Vector> points) {
        this.generateSurface(points);
    }

    @Override
    public void draw(Collection<Player> recipients) {
        assert (this.location != null);
        this.draw(this.location, Quaternion.IDENTITY, this.particle, recipients);
    }

    @Override
    public void draw(DynamicLocation location, Collection<Player> recipients) {
        this.draw(location, Quaternion.IDENTITY, this.particle, recipients);
    }

    @Override
    public void draw(DynamicLocation location, Quaternion baseOrientation, Particle particle, Collection<Player> recipients) {
        if (location.isNull()) {
            if (this.location == null) {
                return;
            }
            location = this.location.clone();
        }
        this.lastLocation = location.clone();
        this.lastOrientation.set((Quaternionfc)baseOrientation.clone().mul((Quaternionfc)this.orientation));
        if (!particle.override()) {
            this.particle.parent(this);
            particle = this.particle;
            @Nullable ParticleGradient gradient = particle.gradient();
            if (gradient != null && gradient.isLocal()) {
                gradient.setOrientation(this.lastOrientation);
            }
        }
        particle.receivers(recipients);
        Set<Vector> toDraw = this.getPoints(this.lastOrientation);
        if (this.animationDuration > 0L) {
            int particleCount = toDraw.size();
            double millisecondsPerPoint = (double)this.animationDuration / (double)particleCount;
            final Iterator<List<Vector>> batchIterator = MathUtil.batch(toDraw, millisecondsPerPoint).iterator();
            final Particle finalParticle = particle;
            BukkitRunnable runnable = new BukkitRunnable(){

                public void run() {
                    if (!batchIterator.hasNext()) {
                        this.cancel();
                        return;
                    }
                    List batch = (List)batchIterator.next();
                    try {
                        for (Vector point : batch) {
                            finalParticle.spawn(point);
                        }
                    }
                    catch (IllegalArgumentException e) {
                        Skript.error((String)("Failed to spawn particle! Error: " + e.getMessage()));
                    }
                }
            };
            runnable.runTaskTimerAsynchronously((Plugin)Skript.getInstance(), 0L, 1L);
        } else {
            for (Vector point : toDraw) {
                try {
                    particle.spawn(point);
                }
                catch (IllegalArgumentException e) {
                    Skript.error((String)("Failed to spawn particle! Error: " + e.getMessage()));
                    return;
                }
            }
        }
        if (this.drawLocalAxes) {
            ParticleUtil.drawAxes(location.getLocation().add(this.offset), this.lastOrientation, recipients);
        }
        if (this.drawGlobalAxes) {
            ParticleUtil.drawAxes(location.getLocation().add(this.offset), Quaternion.IDENTITY, recipients);
        }
    }

    @Override
    public void draw(DynamicLocation location, Consumer<Shape> consumer, Collection<Player> recipients) {
        consumer.accept(this);
        this.draw(location, this.orientation, this.particle, recipients);
    }

    @Override
    public Vector getRelativeXAxis(boolean useLastOrientation) {
        return (useLastOrientation ? this.lastOrientation : this.orientation).transform(new Vector(1, 0, 0));
    }

    @Override
    public Vector getRelativeYAxis(boolean useLastOrientation) {
        return (useLastOrientation ? this.lastOrientation : this.orientation).transform(new Vector(0, 1, 0));
    }

    @Override
    public Vector getRelativeZAxis(boolean useLastOrientation) {
        return (useLastOrientation ? this.lastOrientation : this.orientation).transform(new Vector(0, 0, 1));
    }

    @Override
    public void showLocalAxes(boolean show) {
        this.drawLocalAxes = show;
    }

    @Override
    public boolean showLocalAxes() {
        return this.drawLocalAxes;
    }

    @Override
    public void showGlobalAxes(boolean show) {
        this.drawGlobalAxes = show;
    }

    @Override
    public boolean showGlobalAxes() {
        return this.drawGlobalAxes;
    }

    @Override
    public @Nullable DynamicLocation getLastLocation() {
        return this.lastLocation;
    }

    @Override
    public Shape.Style getStyle() {
        return this.style;
    }

    @Override
    public void setStyle(Shape.Style style) {
        this.style = style;
        this.setNeedsUpdate(true);
    }

    @Override
    public Quaternion getOrientation() {
        return new Quaternion(this.orientation);
    }

    @Override
    public void setOrientation(Quaternionf orientation) {
        this.orientation.set((Quaternionfc)orientation);
        this.setNeedsUpdate(true);
    }

    @Override
    public double getScale() {
        return this.scale;
    }

    @Override
    public void setScale(double scale) {
        this.scale = scale;
        this.setNeedsUpdate(true);
    }

    @Override
    public Vector getOffset() {
        return this.offset.clone();
    }

    @Override
    public void setOffset(Vector offset) {
        this.offset = offset;
        this.setNeedsUpdate(true);
    }

    @Override
    public @Nullable DynamicLocation getLocation() {
        if (this.location == null) {
            return null;
        }
        return this.location.clone();
    }

    @Override
    public void setLocation(DynamicLocation location) {
        this.location = location;
    }

    @Override
    public UUID getUUID() {
        return this.uuid;
    }

    @Override
    public Particle getParticle() {
        return this.particle.clone();
    }

    @Override
    public void setParticle(Particle particle) {
        this.particle = particle;
    }

    @Override
    public @Nullable Comparator<Vector> getOrdering() {
        return this.ordering;
    }

    @Override
    public void setOrdering(Comparator<Vector> comparator) {
        this.ordering = comparator;
        this.setNeedsUpdate(true);
    }

    @Override
    public double getParticleDensity() {
        return this.particleDensity;
    }

    @Override
    public void setParticleDensity(double particleDensity) {
        this.particleDensity = Math.max(particleDensity, 1.0E-4);
        this.setNeedsUpdate(true);
    }

    @Override
    public int getParticleCount() {
        return this.getPoints().size();
    }

    @Override
    public boolean needsUpdate() {
        return this.needsUpdate;
    }

    @Override
    public void setNeedsUpdate(boolean needsUpdate) {
        this.needsUpdate = needsUpdate;
    }

    @Override
    public long getAnimationDuration() {
        return this.animationDuration;
    }

    @Override
    public void setAnimationDuration(long animationDuration) {
        this.animationDuration = animationDuration;
    }

    @Override
    @Contract(value="-> new")
    public abstract Shape clone();

    @Override
    @Contract(value="_ -> param1")
    public Shape copyTo(Shape shape) {
        shape.setOrientation(this.orientation);
        shape.setScale(this.scale);
        shape.setOffset(this.offset.clone());
        shape.setParticle(this.particle.clone());
        if (this.location != null) {
            shape.setLocation(this.location.clone());
        }
        shape.setParticleDensity(this.particleDensity);
        shape.setStyle(this.style);
        shape.showLocalAxes(this.drawLocalAxes);
        shape.showGlobalAxes(this.drawGlobalAxes);
        shape.setPoints(this.getPoints());
        shape.setNeedsUpdate(this.needsUpdate);
        shape.setLastState(this.lastState);
        return shape;
    }

    @Override
    @Contract(value="-> new")
    public Shape.State getState() {
        return new Shape.State(this.style, this.orientation.hashCode(), this.scale, this.offset.hashCode(), this.particleDensity);
    }

    @Override
    @Contract(value="_ -> new")
    public Shape.State getState(Quaternion orientation) {
        return new Shape.State(this.style, orientation.hashCode(), this.scale, this.offset.hashCode(), this.particleDensity);
    }

    @Override
    public void setLastState(Shape.State state) {
        this.lastState = state;
    }
}

