/*
 * Decompiled with CFR 0.152.
 */
package com.sovdee.skriptparticles.shapes;

import com.sovdee.skriptparticles.shapes.Circle;
import com.sovdee.skriptparticles.shapes.CutoffShape;
import com.sovdee.skriptparticles.shapes.Shape;
import com.sovdee.skriptparticles.util.MathUtil;
import java.util.Set;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.Contract;

public class Arc
extends Circle
implements CutoffShape {
    public Arc(double radius, double cutoffAngle) {
        super(radius);
        this.cutoffAngle = MathUtil.clamp(cutoffAngle, 0.0, Math.PI * 2);
    }

    public Arc(double radius, double height, double cutoffAngle) {
        super(radius, height);
        this.cutoffAngle = MathUtil.clamp(cutoffAngle, 0.0, Math.PI * 2);
    }

    @Override
    @Contract(pure=true)
    public void generateSurface(Set<Vector> points) {
        this.generateFilled(points);
    }

    @Override
    public double getCutoffAngle() {
        return this.cutoffAngle;
    }

    @Override
    public void setCutoffAngle(double cutoffAngle) {
        this.cutoffAngle = MathUtil.clamp(cutoffAngle, 0.0, Math.PI * 2);
        this.setNeedsUpdate(true);
    }

    @Override
    @Contract(value="-> new")
    public Shape clone() {
        return this.copyTo(new Arc(this.getRadius(), this.getHeight(), this.cutoffAngle));
    }

    @Override
    public String toString() {
        return "Arc{radius=" + this.getRadius() + ", cutoffAngle=" + this.cutoffAngle + ", height=" + this.getHeight() + "}";
    }
}

