/*
 * Decompiled with CFR 0.152.
 */
package com.sovdee.skriptparticles.shapes;

import com.sovdee.skriptparticles.shapes.AbstractShape;
import com.sovdee.skriptparticles.shapes.Shape;
import com.sovdee.skriptparticles.util.Point;
import com.sovdee.skriptparticles.util.Quaternion;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.bukkit.Location;
import org.bukkit.util.Vector;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.jetbrains.annotations.Contract;

public class BezierCurve
extends AbstractShape {
    private Point<?> start;
    private Point<?> end;
    private List<Point<?>> controlPoints;
    private boolean isDynamic;

    public BezierCurve(Point<?> start, Point<?> end, List<Point<?>> controlPoints) {
        this.start = start;
        if (start.getType() != Vector.class) {
            this.setLocation(start.getDynamicLocation());
        }
        this.end = end;
        this.controlPoints = new ArrayList(controlPoints);
        this.isDynamic = true;
    }

    public BezierCurve(BezierCurve curve) {
        this.start = curve.getStart();
        this.end = curve.getEnd();
        this.controlPoints = new ArrayList(curve.getControlPoints());
        this.isDynamic = curve.isDynamic;
    }

    @Override
    @Contract(pure=true)
    public Set<Vector> getPoints(Quaternion orientation) {
        Set<Vector> points = super.getPoints(orientation);
        if (this.isDynamic) {
            this.setNeedsUpdate(true);
        }
        return points;
    }

    private List<Vector> evaluateControlPoints() {
        ArrayList<Vector> controlPoints = new ArrayList<Vector>();
        @Nullable Location origin = this.start.getLocation();
        controlPoints.add(this.start.getVector(origin));
        for (Point<?> controlPoint : this.controlPoints) {
            controlPoints.add(controlPoint.getVector(origin));
        }
        controlPoints.add(this.end.getVector(origin));
        return controlPoints;
    }

    @Override
    public void generateOutline(Set<Vector> points) {
        List<Vector> controlPoints = this.evaluateControlPoints();
        int steps = (int)(this.estimateLength(controlPoints) / this.getParticleDensity());
        for (double step = 0.0; step < (double)steps; step += 1.0) {
            double t = step / (double)steps;
            double nt = 1.0 - t;
            ArrayList<Vector> tempCP = new ArrayList<Vector>(controlPoints);
            while (tempCP.size() > 1) {
                for (int i = 0; i < tempCP.size() - 1; ++i) {
                    tempCP.set(i, ((Vector)tempCP.get(i)).clone().multiply(nt).add(((Vector)tempCP.get(i + 1)).clone().multiply(t)));
                }
                tempCP.remove(tempCP.size() - 1);
            }
            points.add((Vector)tempCP.get(0));
        }
    }

    private double estimateLength() {
        return this.estimateLength(this.evaluateControlPoints());
    }

    private double estimateLength(List<Vector> controlPoints) {
        double dist = 0.0;
        for (int i = 0; i < controlPoints.size() - 1; ++i) {
            dist += controlPoints.get(i).distance(controlPoints.get(i + 1));
        }
        return dist;
    }

    @Override
    public void setParticleCount(int particleCount) {
        particleCount = Math.max(particleCount, 1);
        this.setParticleDensity(this.estimateLength() / (double)particleCount);
        this.setNeedsUpdate(true);
    }

    public Point<?> getStart() {
        return this.start;
    }

    public Point<?> getEnd() {
        return this.end;
    }

    public List<Point<?>> getControlPoints() {
        return this.controlPoints;
    }

    @Override
    public Shape clone() {
        return this.copyTo(new BezierCurve(this));
    }
}

