/*
 * Decompiled with CFR 0.152.
 */
package com.sovdee.skriptparticles.shapes;

import com.sovdee.skriptparticles.shapes.AbstractShape;
import com.sovdee.skriptparticles.shapes.LWHShape;
import com.sovdee.skriptparticles.shapes.RadialShape;
import com.sovdee.skriptparticles.shapes.Shape;
import com.sovdee.skriptparticles.util.MathUtil;
import java.util.Set;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.Contract;

public class Circle
extends AbstractShape
implements RadialShape,
LWHShape {
    private double radius;
    protected double cutoffAngle;
    private double height;

    public Circle(double radius) {
        this(radius, 0.0);
    }

    public Circle(double radius, double height) {
        this.radius = Math.max(radius, 1.0E-4);
        this.height = Math.max(height, 0.0);
        this.cutoffAngle = Math.PI * 2;
    }

    @Override
    @Contract(pure=true)
    public void generateOutline(Set<Vector> points) {
        Set<Vector> circle = MathUtil.calculateCircle(this.radius, this.getParticleDensity(), this.cutoffAngle);
        if (this.height != 0.0) {
            points.addAll(MathUtil.fillVertically(circle, this.height, this.getParticleDensity()));
        } else {
            points.addAll(circle);
        }
    }

    @Override
    @Contract(pure=true)
    public void generateSurface(Set<Vector> points) {
        if (this.height != 0.0) {
            points.addAll(MathUtil.calculateCylinder(this.radius, this.height, this.getParticleDensity(), this.cutoffAngle));
        } else {
            points.addAll(MathUtil.calculateDisc(this.radius, this.getParticleDensity(), this.cutoffAngle));
        }
    }

    @Override
    @Contract(pure=true)
    public void generateFilled(Set<Vector> points) {
        Set<Vector> disc = MathUtil.calculateDisc(this.radius, this.getParticleDensity(), this.cutoffAngle);
        if (this.height != 0.0) {
            points.addAll(MathUtil.fillVertically(disc, this.height, this.getParticleDensity()));
        } else {
            points.addAll(disc);
        }
    }

    @Override
    public void setParticleCount(int particleCount) {
        particleCount = Math.max(particleCount, 1);
        if (this.getStyle() == Shape.Style.OUTLINE && this.height == 0.0) {
            this.setParticleDensity(this.cutoffAngle * this.radius / (double)particleCount);
        } else if (this.getStyle() == Shape.Style.SURFACE || this.height == 0.0) {
            double discArea = this.cutoffAngle * 0.5 * this.radius * this.radius;
            double wallArea = this.cutoffAngle * this.radius * this.height;
            this.setParticleDensity(Math.sqrt((discArea + wallArea) / (double)particleCount));
        } else {
            this.setParticleDensity(Math.cbrt(this.cutoffAngle * 0.5 * this.radius * this.radius * this.height / (double)particleCount));
        }
        this.setNeedsUpdate(true);
    }

    @Override
    public double getRadius() {
        return this.radius;
    }

    @Override
    public void setRadius(double radius) {
        this.radius = Math.max(radius, 1.0E-4);
        this.setNeedsUpdate(true);
    }

    @Override
    public double getLength() {
        return 0.0;
    }

    @Override
    public void setLength(double length) {
    }

    @Override
    public double getWidth() {
        return 0.0;
    }

    @Override
    public void setWidth(double width) {
    }

    @Override
    public double getHeight() {
        return this.height;
    }

    @Override
    public void setHeight(double height) {
        this.height = Math.max(height, 0.0);
        this.setNeedsUpdate(true);
    }

    @Override
    @Contract(value="-> new")
    public Shape clone() {
        return this.copyTo(new Circle(this.radius, this.height));
    }

    public String toString() {
        return "Circle{radius=" + this.radius + ", cutoffAngle=" + this.cutoffAngle + ", height=" + this.height + "}";
    }
}

