/*
 * Decompiled with CFR 0.152.
 */
package com.sovdee.skriptparticles.shapes;

import com.sovdee.skriptparticles.shapes.AbstractShape;
import com.sovdee.skriptparticles.shapes.LWHShape;
import com.sovdee.skriptparticles.shapes.Shape;
import com.sovdee.skriptparticles.util.DynamicLocation;
import com.sovdee.skriptparticles.util.Quaternion;
import java.util.Set;
import org.bukkit.Location;
import org.bukkit.util.Vector;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class Cuboid
extends AbstractShape
implements LWHShape {
    private double halfLength;
    private double halfWidth;
    private double halfHeight;
    private double lengthStep;
    private double widthStep;
    private double heightStep;
    private Vector centerOffset = new Vector(0, 0, 0);
    private @Nullable DynamicLocation negativeCorner;
    private @Nullable DynamicLocation positiveCorner;
    private boolean isDynamic = false;

    public Cuboid(double length, double width, double height) {
        this.halfWidth = Math.max(width / 2.0, 1.0E-4);
        this.halfLength = Math.max(length / 2.0, 1.0E-4);
        this.halfHeight = Math.max(height / 2.0, 1.0E-4);
        this.calculateSteps();
    }

    public Cuboid(Vector cornerA, Vector cornerB) {
        if (cornerA.equals((Object)cornerB)) {
            throw new IllegalArgumentException("Cuboid corners cannot be equal.");
        }
        this.halfLength = Math.abs(cornerB.getX() - cornerA.getX()) / 2.0;
        this.halfWidth = Math.abs(cornerB.getZ() - cornerA.getZ()) / 2.0;
        this.halfHeight = Math.abs(cornerB.getY() - cornerA.getY()) / 2.0;
        this.centerOffset = cornerB.clone().add(cornerA).multiply(0.5);
        this.calculateSteps();
    }

    public Cuboid(DynamicLocation cornerA, DynamicLocation cornerB) {
        Location cornerBLocation;
        if (cornerA.equals(cornerB)) {
            throw new IllegalArgumentException("Cuboid corners cannot be equal.");
        }
        Location cornerALocation = cornerA.getLocation();
        if (cornerALocation.equals((Object)(cornerBLocation = cornerB.getLocation()))) {
            throw new IllegalArgumentException("Cuboid corners cannot be equal.");
        }
        if (cornerA.isDynamic() || cornerB.isDynamic()) {
            this.negativeCorner = cornerA.clone();
            this.positiveCorner = cornerB.clone();
            this.isDynamic = true;
        } else {
            this.halfLength = Math.abs(cornerBLocation.getX() - cornerALocation.getX()) / 2.0;
            this.halfWidth = Math.abs(cornerBLocation.getZ() - cornerALocation.getZ()) / 2.0;
            this.halfHeight = Math.abs(cornerBLocation.getY() - cornerALocation.getY()) / 2.0;
        }
        this.setLocation(new DynamicLocation(cornerALocation.clone().add(cornerBLocation.subtract(cornerALocation).toVector().multiply(0.5))));
        this.calculateSteps();
    }

    private void calculateSteps() {
        this.widthStep = 2.0 * this.halfWidth / (double)Math.round(2.0 * this.halfWidth / this.getParticleDensity());
        this.lengthStep = 2.0 * this.halfLength / (double)Math.round(2.0 * this.halfLength / this.getParticleDensity());
        this.heightStep = 2.0 * this.halfHeight / (double)Math.round(2.0 * this.halfHeight / this.getParticleDensity());
    }

    @Override
    @Contract(pure=true)
    public void generateOutline(Set<Vector> points) {
        for (double x = -this.halfLength; x <= this.halfLength; x += this.lengthStep) {
            points.add(new Vector(x, -this.halfHeight, -this.halfWidth));
            points.add(new Vector(x, -this.halfHeight, this.halfWidth));
            points.add(new Vector(x, this.halfHeight, -this.halfWidth));
            points.add(new Vector(x, this.halfHeight, this.halfWidth));
        }
        for (double y = -this.halfHeight + this.heightStep; y < this.halfHeight; y += this.heightStep) {
            points.add(new Vector(-this.halfLength, y, -this.halfWidth));
            points.add(new Vector(-this.halfLength, y, this.halfWidth));
            points.add(new Vector(this.halfLength, y, -this.halfWidth));
            points.add(new Vector(this.halfLength, y, this.halfWidth));
        }
        for (double z = -this.halfWidth + this.widthStep; z < this.halfWidth; z += this.widthStep) {
            points.add(new Vector(-this.halfLength, -this.halfHeight, z));
            points.add(new Vector(-this.halfLength, this.halfHeight, z));
            points.add(new Vector(this.halfLength, -this.halfHeight, z));
            points.add(new Vector(this.halfLength, this.halfHeight, z));
        }
    }

    @Override
    @Contract(pure=true)
    public void generateSurface(Set<Vector> points) {
        double z;
        double x;
        for (x = -this.halfLength; x <= this.halfLength; x += this.lengthStep) {
            for (z = -this.halfWidth; z <= this.halfWidth; z += this.widthStep) {
                points.add(new Vector(x, -this.halfHeight, z));
                points.add(new Vector(x, this.halfHeight, z));
            }
        }
        for (double y = -this.halfHeight + this.heightStep; y < this.halfHeight; y += this.heightStep) {
            for (z = -this.halfWidth; z <= this.halfWidth; z += this.widthStep) {
                points.add(new Vector(-this.halfLength, y, z));
                points.add(new Vector(this.halfLength, y, z));
            }
        }
        for (x = -this.halfLength + this.lengthStep; x < this.halfLength; x += this.lengthStep) {
            for (double y = -this.halfHeight + this.heightStep; y < this.halfHeight; y += this.heightStep) {
                points.add(new Vector(x, y, -this.halfWidth));
                points.add(new Vector(x, y, this.halfWidth));
            }
        }
    }

    @Override
    @Contract(pure=true)
    public void generateFilled(Set<Vector> points) {
        for (double x = -this.halfLength; x <= this.halfLength; x += this.lengthStep) {
            for (double y = -this.halfHeight; y <= this.halfHeight; y += this.heightStep) {
                for (double z = -this.halfWidth; z <= this.halfWidth; z += this.widthStep) {
                    points.add(new Vector(x, y, z));
                }
            }
        }
    }

    @Override
    @Contract(pure=true)
    public void generatePoints(Set<Vector> points) {
        if (this.isDynamic) {
            assert (this.negativeCorner != null);
            assert (this.positiveCorner != null);
            Location negative = this.negativeCorner.getLocation();
            Location positive = this.positiveCorner.getLocation();
            this.halfLength = Math.abs(positive.getX() - negative.getX()) / 2.0;
            this.halfWidth = Math.abs(positive.getZ() - negative.getZ()) / 2.0;
            this.halfHeight = Math.abs(positive.getY() - negative.getY()) / 2.0;
            this.setLocation(new DynamicLocation(negative.clone().add(positive.subtract(negative).toVector().multiply(0.5))));
        }
        this.calculateSteps();
        super.generatePoints(points);
        points.forEach(vector -> vector.add(this.centerOffset));
    }

    @Override
    public Set<Vector> getPoints(@NonNull @NotNull Quaternion orientation) {
        Set<Vector> points = super.getPoints(orientation);
        if (this.isDynamic) {
            this.setNeedsUpdate(true);
        }
        return points;
    }

    @Override
    public void setParticleCount(int particleCount) {
        particleCount = Math.max(1, particleCount);
        this.setParticleDensity(switch (this.getStyle()) {
            default -> throw new IncompatibleClassChangeError();
            case Shape.Style.OUTLINE -> 8.0 * (this.halfLength + this.halfHeight + this.halfWidth) / (double)particleCount;
            case Shape.Style.SURFACE -> Math.sqrt(8.0 * (this.halfLength * this.halfHeight + this.halfLength * this.halfWidth + this.halfHeight * this.halfWidth) / (double)particleCount);
            case Shape.Style.FILL -> Math.cbrt(8.0 * this.halfLength * this.halfHeight * this.halfWidth / (double)particleCount);
        });
        this.calculateSteps();
        this.setNeedsUpdate(true);
    }

    @Override
    public double getLength() {
        return this.halfLength * 2.0;
    }

    @Override
    public void setLength(double length) {
        this.halfLength = Math.max(length / 2.0, 1.0E-4);
        this.setNeedsUpdate(true);
    }

    @Override
    public double getWidth() {
        return this.halfWidth * 2.0;
    }

    @Override
    public void setWidth(double width) {
        this.halfWidth = Math.max(width / 2.0, 1.0E-4);
        this.setNeedsUpdate(true);
    }

    @Override
    public double getHeight() {
        return this.halfHeight * 2.0;
    }

    @Override
    public void setHeight(double height) {
        this.halfHeight = Math.max(height / 2.0, 1.0E-4);
        this.setNeedsUpdate(true);
    }

    @Override
    @Contract(value="-> new")
    public Shape clone() {
        Cuboid cuboid;
        if (this.isDynamic) {
            assert (this.negativeCorner != null);
            assert (this.positiveCorner != null);
            cuboid = new Cuboid(this.negativeCorner, this.positiveCorner);
        } else {
            cuboid = new Cuboid(this.getLength(), this.getWidth(), this.getHeight());
        }
        cuboid.isDynamic = this.isDynamic;
        return this.copyTo(cuboid);
    }
}

