/*
 * Decompiled with CFR 0.152.
 */
package com.sovdee.skriptparticles.shapes;

import com.sovdee.skriptparticles.shapes.AbstractShape;
import com.sovdee.skriptparticles.shapes.LWHShape;
import com.sovdee.skriptparticles.shapes.Shape;
import com.sovdee.skriptparticles.util.MathUtil;
import java.util.LinkedHashSet;
import java.util.Set;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.Contract;

public class Ellipse
extends AbstractShape
implements LWHShape {
    private double xRadius;
    private double zRadius;
    private double height;
    protected double cutoffAngle;

    public Ellipse(double xRadius, double zRadius) {
        this(xRadius, zRadius, 0.0);
    }

    public Ellipse(double xRadius, double zRadius, double height) {
        this.xRadius = Math.max(xRadius, 1.0E-4);
        this.zRadius = Math.max(zRadius, 1.0E-4);
        this.height = Math.max(height, 0.0);
        this.cutoffAngle = Math.PI * 2;
    }

    @Override
    @Contract(pure=true)
    public void generateOutline(Set<Vector> points) {
        LinkedHashSet<Vector> ellipse = new LinkedHashSet<Vector>(MathUtil.calculateEllipse(this.xRadius, this.zRadius, this.getParticleDensity(), this.cutoffAngle));
        if (this.height != 0.0) {
            points.addAll(MathUtil.fillVertically(ellipse, this.height, this.getParticleDensity()));
        } else {
            points.addAll(ellipse);
        }
    }

    @Override
    @Contract(pure=true)
    public void generateSurface(Set<Vector> points) {
        if (this.height != 0.0) {
            points.addAll(MathUtil.calculateCylinder(this.xRadius, this.zRadius, this.height, this.getParticleDensity(), this.cutoffAngle));
        } else {
            points.addAll(MathUtil.calculateEllipticalDisc(this.xRadius, this.zRadius, this.getParticleDensity(), this.cutoffAngle));
        }
    }

    @Override
    @Contract(pure=true)
    public void generateFilled(Set<Vector> points) {
        Set<Vector> disc = MathUtil.calculateEllipticalDisc(this.xRadius, this.zRadius, this.getParticleDensity(), this.cutoffAngle);
        if (this.height != 0.0) {
            points.addAll(MathUtil.fillVertically(disc, this.height, this.getParticleDensity()));
        } else {
            points.addAll(disc);
        }
    }

    @Override
    public void setParticleCount(int particleCount) {
        particleCount = Math.max(particleCount, 1);
        switch (this.getStyle()) {
            case OUTLINE: {
                double h = (this.xRadius - this.zRadius) * (this.xRadius - this.zRadius) / (this.xRadius + this.zRadius + (this.xRadius + this.zRadius));
                double circumferenceXY = Math.PI * (this.xRadius + this.zRadius) * (1.0 + 3.0 * h / (10.0 + Math.sqrt(4.0 - 3.0 * h)));
                this.setParticleDensity(circumferenceXY / (double)particleCount);
                break;
            }
            case SURFACE: 
            case FILL: {
                this.setParticleDensity(Math.sqrt(Math.PI * this.xRadius * this.zRadius / (double)particleCount));
            }
        }
    }

    @Override
    public double getLength() {
        return this.xRadius * 2.0;
    }

    @Override
    public void setLength(double length) {
        this.xRadius = Math.max(length / 2.0, 1.0E-4);
        this.setNeedsUpdate(true);
    }

    @Override
    public double getWidth() {
        return this.zRadius * 2.0;
    }

    @Override
    public void setWidth(double width) {
        this.zRadius = Math.max(width / 2.0, 1.0E-4);
        this.setNeedsUpdate(true);
    }

    @Override
    public double getHeight() {
        return this.height;
    }

    @Override
    public void setHeight(double height) {
        this.height = Math.max(height, 0.0);
        this.setNeedsUpdate(true);
    }

    @Override
    @Contract(value="-> new")
    public Shape clone() {
        return this.copyTo(new Ellipse(this.xRadius, this.zRadius, this.height));
    }
}

