/*
 * Decompiled with CFR 0.152.
 */
package com.sovdee.skriptparticles.shapes;

import com.sovdee.skriptparticles.shapes.AbstractShape;
import com.sovdee.skriptparticles.shapes.LWHShape;
import com.sovdee.skriptparticles.shapes.Shape;
import com.sovdee.skriptparticles.util.MathUtil;
import com.sovdee.skriptparticles.util.Quaternion;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.Contract;

public class Ellipsoid
extends AbstractShape
implements LWHShape {
    private static final Quaternion XY_ROTATION = new Quaternion(new Vector(1, 0, 0), 1.5707964f);
    private static final Quaternion ZY_ROTATION = new Quaternion(new Vector(0, 0, 1), 1.5707964f);
    protected double xRadius;
    protected double yRadius;
    protected double zRadius;

    public Ellipsoid(double xRadius, double yRadius, double zRadius) {
        this.xRadius = Math.max(xRadius, 1.0E-4);
        this.yRadius = Math.max(yRadius, 1.0E-4);
        this.zRadius = Math.max(zRadius, 1.0E-4);
    }

    @Override
    @Contract(pure=true)
    public void generateOutline(Set<Vector> points) {
        double particleDensity = this.getParticleDensity();
        points.addAll(MathUtil.calculateEllipse(this.xRadius, this.zRadius, particleDensity, Math.PI * 2));
        points.addAll(XY_ROTATION.transform(MathUtil.calculateEllipse(this.xRadius, this.yRadius, particleDensity, Math.PI * 2)));
        points.addAll(ZY_ROTATION.transform(MathUtil.calculateEllipse(this.yRadius, this.zRadius, particleDensity, Math.PI * 2)));
    }

    @Override
    @Contract(pure=true)
    public void generateSurface(Set<Vector> points) {
        double particleDensity = this.getParticleDensity();
        List<Vector> ellipse = this.xRadius > this.zRadius ? XY_ROTATION.transform(MathUtil.calculateEllipse(this.xRadius, this.yRadius, particleDensity, Math.PI * 2)) : ZY_ROTATION.transform(MathUtil.calculateEllipse(this.yRadius, this.zRadius, particleDensity, Math.PI * 2));
        points.addAll(this.generateEllipsoid(ellipse, 1.0));
    }

    @Override
    @Contract(pure=true)
    public void generateFilled(Set<Vector> points) {
        int steps;
        double radius = Math.max(this.xRadius, this.zRadius);
        double particleDensity = this.getParticleDensity();
        for (int i = steps = (int)Math.round(radius / particleDensity); i > 0; --i) {
            double r = (double)i / (double)steps;
            List<Vector> ellipse = this.xRadius > this.zRadius ? XY_ROTATION.transform(MathUtil.calculateEllipse(this.xRadius * r, this.yRadius * r, particleDensity, Math.PI * 2)) : ZY_ROTATION.transform(MathUtil.calculateEllipse(this.yRadius * r, this.zRadius * r, particleDensity, Math.PI * 2));
            points.addAll(this.generateEllipsoid(ellipse, r));
        }
    }

    private Set<Vector> generateEllipsoid(List<Vector> ellipse, double radius) {
        LinkedHashSet<Vector> points = new LinkedHashSet<Vector>();
        int i = 0;
        while ((double)i < Math.ceil((double)ellipse.size() / 4.0)) {
            double y = ellipse.get(i).getY();
            double theta = Math.asin(y / (this.yRadius * radius));
            for (Vector v2 : MathUtil.calculateEllipse(radius * this.xRadius * Math.cos(theta), radius * this.zRadius * Math.cos(theta), this.getParticleDensity(), Math.PI * 2)) {
                points.add(new Vector(v2.getX(), y, v2.getZ()));
                points.add(new Vector(v2.getX(), -y, v2.getZ()));
            }
            ++i;
        }
        points.addAll(MathUtil.calculateEllipse(radius * this.xRadius, radius * this.zRadius, this.getParticleDensity(), Math.PI * 2));
        return points;
    }

    @Override
    public void setParticleCount(int particleCount) {
        particleCount = Math.max(particleCount, 1);
        switch (this.getStyle()) {
            case OUTLINE: {
                double h = (this.xRadius - this.yRadius) * (this.xRadius - this.yRadius) / (this.xRadius + this.yRadius + (this.xRadius + this.yRadius));
                double circumferenceXY = Math.PI * (this.xRadius + this.yRadius) * (1.0 + 3.0 * h / (10.0 + Math.sqrt(4.0 - 3.0 * h)));
                h = (this.xRadius - this.zRadius) * (this.xRadius - this.zRadius) / (this.xRadius + this.zRadius + (this.xRadius + this.zRadius));
                double circumferenceXZ = Math.PI * (this.xRadius + this.zRadius) * (1.0 + 3.0 * h / (10.0 + Math.sqrt(4.0 - 3.0 * h)));
                h = (this.yRadius - this.zRadius) * (this.yRadius - this.zRadius) / (this.yRadius + this.zRadius + (this.yRadius + this.zRadius));
                double circumferenceYZ = Math.PI * (this.yRadius + this.zRadius) * (1.0 + 3.0 * h / (10.0 + Math.sqrt(4.0 - 3.0 * h)));
                this.setParticleDensity((circumferenceXY + circumferenceXZ + circumferenceYZ) / (double)particleCount);
                break;
            }
            case SURFACE: {
                double surfaceArea = Math.PI * 4 * Math.pow((Math.pow(this.xRadius * this.yRadius, 1.6) + Math.pow(this.xRadius * this.zRadius, 1.6) + Math.pow(this.zRadius * this.yRadius, 1.6)) / 3.0, 0.625);
                this.setParticleDensity(Math.sqrt(surfaceArea / (double)particleCount));
                break;
            }
            case FILL: {
                double volume = 4.1887902047863905 * this.xRadius * this.yRadius * this.zRadius;
                this.setParticleDensity(Math.cbrt(volume / (double)particleCount));
            }
        }
    }

    @Override
    public double getLength() {
        return this.xRadius * 2.0;
    }

    @Override
    public void setLength(double length) {
        this.xRadius = Math.max(length / 2.0, 1.0E-4);
        this.setNeedsUpdate(true);
    }

    @Override
    public double getWidth() {
        return this.zRadius * 2.0;
    }

    @Override
    public void setWidth(double width) {
        this.zRadius = Math.max(width / 2.0, 1.0E-4);
        this.setNeedsUpdate(true);
    }

    @Override
    public double getHeight() {
        return this.yRadius * 2.0;
    }

    @Override
    public void setHeight(double height) {
        this.yRadius = Math.max(height / 2.0, 1.0E-4);
        this.setNeedsUpdate(true);
    }

    @Override
    @Contract(value="-> new")
    public Shape clone() {
        return this.copyTo(new Ellipsoid(this.xRadius, this.yRadius, this.zRadius));
    }
}

