/*
 * Decompiled with CFR 0.152.
 */
package com.sovdee.skriptparticles.shapes;

import com.sovdee.skriptparticles.shapes.CutoffShape;
import com.sovdee.skriptparticles.shapes.Ellipse;
import com.sovdee.skriptparticles.shapes.Shape;
import com.sovdee.skriptparticles.util.MathUtil;
import java.util.Set;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.Contract;

public class EllipticalArc
extends Ellipse
implements CutoffShape {
    public EllipticalArc(double xRadius, double zRadius, double cutoffAngle) {
        this(xRadius, zRadius, 0.0, cutoffAngle);
    }

    public EllipticalArc(double xRadius, double zRadius, double height, double cutoffAngle) {
        super(xRadius, zRadius, height);
        this.cutoffAngle = MathUtil.clamp(cutoffAngle, 0.0, Math.PI * 2);
    }

    @Override
    @Contract(pure=true)
    public void generateSurface(Set<Vector> points) {
        this.generateFilled(points);
    }

    @Override
    public double getCutoffAngle() {
        return this.cutoffAngle;
    }

    @Override
    public void setCutoffAngle(double cutoffAngle) {
        this.cutoffAngle = MathUtil.clamp(cutoffAngle, 0.0, Math.PI * 2);
        this.setNeedsUpdate(true);
    }

    @Override
    @Contract(value="-> new")
    public Shape clone() {
        return this.copyTo(new EllipticalArc(this.getLength(), this.getWidth(), this.getHeight(), this.cutoffAngle));
    }
}

