/*
 * Decompiled with CFR 0.152.
 */
package com.sovdee.skriptparticles.shapes;

import com.sovdee.skriptparticles.shapes.AbstractShape;
import com.sovdee.skriptparticles.shapes.LWHShape;
import com.sovdee.skriptparticles.shapes.Shape;
import com.sovdee.skriptparticles.util.MathUtil;
import java.util.Set;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.Contract;

public class Heart
extends AbstractShape
implements LWHShape {
    private double length;
    private double width;
    private double eccentricity;

    public Heart(double length, double width, double eccentricity) {
        this.length = Math.max(length, 1.0E-4);
        this.width = Math.max(width, 1.0E-4);
        this.eccentricity = Math.max(eccentricity, 1.0);
    }

    @Override
    @Contract(pure=true)
    public void generateOutline(Set<Vector> points) {
        points.addAll(MathUtil.calculateHeart(this.length / 2.0, this.width / 2.0, this.eccentricity, this.getParticleDensity()));
    }

    @Override
    @Contract(pure=true)
    public void generateSurface(Set<Vector> points) {
        double particleDensity = this.getParticleDensity();
        double w = this.width;
        for (double l = this.length; w > 0.0 && l > 0.0; w -= particleDensity * 1.5, l -= particleDensity * 1.5) {
            points.addAll(MathUtil.calculateHeart(l / 2.0, w / 2.0, this.eccentricity, particleDensity));
        }
    }

    @Override
    public void setParticleCount(int particleCount) {
    }

    @Override
    public double getHeight() {
        return 0.0;
    }

    @Override
    public void setHeight(double height) {
    }

    @Override
    public double getWidth() {
        return this.width;
    }

    @Override
    public void setWidth(double width) {
        this.width = Math.max(width, 1.0E-4);
        this.setNeedsUpdate(true);
    }

    @Override
    public double getLength() {
        return this.length;
    }

    @Override
    public void setLength(double length) {
        this.length = Math.max(length, 1.0E-4);
        this.setNeedsUpdate(true);
    }

    public double getEccentricity() {
        return this.eccentricity;
    }

    public void setEccentricity(double eccentricity) {
        this.eccentricity = Math.max(1.0, eccentricity);
        this.setNeedsUpdate(true);
    }

    @Override
    @Contract(value="-> new")
    public Shape clone() {
        return this.copyTo(new Heart(this.length, this.width, this.eccentricity));
    }
}

