/*
 * Decompiled with CFR 0.152.
 */
package com.sovdee.skriptparticles.shapes;

import com.sovdee.skriptparticles.shapes.AbstractShape;
import com.sovdee.skriptparticles.shapes.LWHShape;
import com.sovdee.skriptparticles.shapes.RadialShape;
import com.sovdee.skriptparticles.shapes.Shape;
import com.sovdee.skriptparticles.util.MathUtil;
import java.util.Set;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.Contract;

public class Helix
extends AbstractShape
implements RadialShape,
LWHShape {
    private double radius;
    private double height;
    private double slope;
    private int direction = 1;

    public Helix(double radius, double height, double slope) {
        this.radius = Math.max(radius, 1.0E-4);
        this.height = Math.max(height, 1.0E-4);
        this.slope = Math.max(slope, 1.0E-4);
    }

    public Helix(double radius, double height, double slope, int direction) {
        this.radius = Math.max(radius, 1.0E-4);
        this.height = Math.max(height, 1.0E-4);
        this.slope = Math.max(slope, 1.0E-4);
        if (direction != 1 && direction != -1) {
            throw new IllegalArgumentException("Direction must be 1 or -1");
        }
        this.direction = direction;
    }

    @Override
    @Contract(pure=true)
    public void generateOutline(Set<Vector> points) {
        points.addAll(MathUtil.calculateHelix(this.radius, this.height, this.slope, this.direction, this.getParticleDensity()));
    }

    @Override
    @Contract(pure=true)
    public void generateSurface(Set<Vector> points) {
        double particleDensity = this.getParticleDensity();
        for (double r = this.radius; r > 0.0; r -= particleDensity) {
            points.addAll(MathUtil.calculateHelix(r, this.height, this.slope, this.direction, particleDensity));
        }
    }

    @Override
    public void setParticleCount(int particleCount) {
        particleCount = Math.max(particleCount, 1);
        this.setParticleDensity(switch (this.getStyle()) {
            default -> throw new IncompatibleClassChangeError();
            case Shape.Style.OUTLINE -> Math.sqrt(this.slope * this.slope + this.radius * this.radius) * (this.height / this.slope) / (double)particleCount;
            case Shape.Style.FILL, Shape.Style.SURFACE -> Math.sqrt(this.slope * this.slope + this.radius * this.radius * (this.height / this.slope) / (double)particleCount);
        });
    }

    public double getSlope() {
        return this.slope;
    }

    public void setSlope(double slope) {
        this.slope = Math.max(slope, 1.0E-4);
        this.setNeedsUpdate(true);
    }

    public int getDirection() {
        return this.direction;
    }

    public void setDirection(int direction) {
        if (direction != 1 && direction != -1) {
            throw new IllegalArgumentException("Direction must be 1 or -1");
        }
        this.direction = direction;
        this.setNeedsUpdate(true);
    }

    @Override
    public double getLength() {
        return this.height;
    }

    @Override
    public void setLength(double length) {
        this.height = Math.max(length, 1.0E-4);
        this.setNeedsUpdate(true);
    }

    @Override
    public double getWidth() {
        return 0.0;
    }

    @Override
    public void setWidth(double width) {
    }

    @Override
    public double getHeight() {
        return this.height;
    }

    @Override
    public void setHeight(double height) {
        this.height = Math.max(height, 1.0E-4);
        this.setNeedsUpdate(true);
    }

    @Override
    public double getRadius() {
        return this.radius;
    }

    @Override
    public void setRadius(double radius) {
        this.radius = Math.max(radius, 1.0E-4);
        this.setNeedsUpdate(true);
    }

    @Override
    @Contract(value="-> new")
    public Shape clone() {
        return this.copyTo(new Helix(this.radius, this.height, this.slope, this.direction));
    }
}

