/*
 * Decompiled with CFR 0.152.
 */
package com.sovdee.skriptparticles.shapes;

import com.sovdee.skriptparticles.shapes.AbstractShape;
import com.sovdee.skriptparticles.shapes.LWHShape;
import com.sovdee.skriptparticles.shapes.Shape;
import com.sovdee.skriptparticles.util.MathUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.Contract;

public class IrregularPolygon
extends AbstractShape
implements LWHShape {
    private final List<Vector> vertices;
    private double height;

    public IrregularPolygon(Collection<Vector> vertices) {
        if (vertices.size() < 3) {
            throw new IllegalArgumentException("A polygon must have at least 3 vertices.");
        }
        this.setBounds(vertices);
        this.vertices = this.flattenVertices(vertices);
    }

    public IrregularPolygon(Collection<Vector> vertices, double height) {
        this(vertices);
        this.height = Math.max(height, 0.0);
    }

    @Contract(pure=true, value="_ -> new")
    private List<Vector> flattenVertices(Collection<Vector> vertices) {
        ArrayList<Vector> flattened = new ArrayList<Vector>();
        for (Vector v : vertices) {
            flattened.add(v.clone().setY(0));
        }
        return flattened;
    }

    private void setBounds(Collection<Vector> vertices) {
        double low = 9999999.0;
        double high = -9999999.0;
        for (Vector v : vertices) {
            if (v.getY() < low) {
                low = v.getY();
            }
            if (!(v.getY() > high)) continue;
            high = v.getY();
        }
        this.height = high - low;
    }

    @Override
    @Contract(pure=true)
    public void generateOutline(Set<Vector> points) {
        double particleDensity = this.getParticleDensity();
        points.addAll(MathUtil.connectPoints(this.vertices, particleDensity));
        points.addAll(MathUtil.calculateLine(this.vertices.get(0), this.vertices.get(this.vertices.size() - 1), particleDensity));
        if (this.height != 0.0) {
            LinkedHashSet<Vector> upperPoints = new LinkedHashSet<Vector>();
            for (Vector v : points) {
                upperPoints.add(new Vector(v.getX(), this.height, v.getZ()));
            }
            points.addAll(upperPoints);
            for (Vector v : this.vertices) {
                points.addAll(MathUtil.calculateLine(v, new Vector(v.getX(), this.height, v.getZ()), particleDensity));
            }
        }
    }

    @Override
    public void setParticleCount(int particleCount) {
        particleCount = Math.max(particleCount, 1);
        double perimeter = 0.0;
        for (int i = 0; i < this.vertices.size() - 1; ++i) {
            perimeter += this.vertices.get(i).distance(this.vertices.get(i + 1));
        }
        perimeter += this.vertices.get(0).distance(this.vertices.get(this.vertices.size() - 1));
        perimeter *= 2.0;
        this.setParticleDensity((perimeter += (double)this.vertices.size() * this.height) / (double)particleCount);
        this.setNeedsUpdate(true);
    }

    @Override
    public double getLength() {
        return 0.0;
    }

    @Override
    public void setLength(double length) {
    }

    @Override
    public double getWidth() {
        return 0.0;
    }

    @Override
    public void setWidth(double width) {
    }

    @Override
    public double getHeight() {
        return this.height;
    }

    @Override
    public void setHeight(double height) {
        this.height = Math.max(height, 0.0);
        this.setNeedsUpdate(true);
    }

    @Override
    @Contract(value="-> new")
    public Shape clone() {
        return this.copyTo(new IrregularPolygon(this.vertices, this.height));
    }
}

