/*
 * Decompiled with CFR 0.152.
 */
package com.sovdee.skriptparticles.shapes;

import com.sovdee.skriptparticles.shapes.AbstractShape;
import com.sovdee.skriptparticles.shapes.LWHShape;
import com.sovdee.skriptparticles.shapes.Shape;
import com.sovdee.skriptparticles.util.DynamicLocation;
import com.sovdee.skriptparticles.util.MathUtil;
import com.sovdee.skriptparticles.util.Quaternion;
import java.util.Set;
import org.bukkit.util.Vector;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.jetbrains.annotations.Contract;

public class Line
extends AbstractShape
implements LWHShape {
    private Vector start;
    private Vector end;
    private @Nullable DynamicLocation startLocation;
    private @Nullable DynamicLocation endLocation;
    private boolean isDynamic = false;

    public Line(Vector end) {
        this(new Vector(0, 0, 0), end);
    }

    public Line(Vector start, Vector end) {
        if (start.equals((Object)end)) {
            throw new IllegalArgumentException("Start and end locations cannot be the same.");
        }
        this.start = start;
        this.end = end;
    }

    public Line(DynamicLocation start, DynamicLocation end) {
        if (start.equals(end)) {
            throw new IllegalArgumentException("Start and end locations cannot be the same.");
        }
        if (start.isDynamic() || end.isDynamic()) {
            this.startLocation = start.clone();
            this.endLocation = end.clone();
            this.isDynamic = true;
        }
        this.start = new Vector(0, 0, 0);
        this.end = end.getLocation().toVector().subtract(start.getLocation().toVector());
        if (this.end.equals((Object)this.start)) {
            throw new IllegalArgumentException("Start and end locations cannot be the same.");
        }
        this.setLocation(start.clone());
    }

    @Override
    @Contract(pure=true)
    public Set<Vector> getPoints(Quaternion orientation) {
        Set<Vector> points = super.getPoints(orientation);
        if (this.isDynamic) {
            this.setNeedsUpdate(true);
        }
        return points;
    }

    @Override
    @Contract(pure=true)
    public void generatePoints(Set<Vector> points) {
        if (this.isDynamic) {
            assert (this.startLocation != null);
            assert (this.endLocation != null);
            this.start = new Vector(0, 0, 0);
            this.end = this.endLocation.getLocation().toVector().subtract(this.startLocation.getLocation().toVector());
        }
        super.generatePoints(points);
    }

    @Override
    @Contract(pure=true)
    public void generateOutline(Set<Vector> points) {
        points.addAll(MathUtil.calculateLine(this.start, this.end, this.getParticleDensity()));
    }

    public Vector getStart() {
        if (this.isDynamic) {
            assert (this.startLocation != null);
            return this.startLocation.getLocation().toVector();
        }
        return this.start.clone();
    }

    public void setStart(Vector start) {
        if (start.equals((Object)this.end)) {
            throw new IllegalArgumentException("Start and end points must not be identical");
        }
        this.start = start.clone();
    }

    public Vector getEnd() {
        if (this.isDynamic) {
            assert (this.endLocation != null);
            return this.endLocation.getLocation().toVector();
        }
        return this.end.clone();
    }

    public void setEnd(Vector end) {
        if (end.equals((Object)this.start)) {
            throw new IllegalArgumentException("Start and end points must not be identical");
        }
        this.end = end.clone();
    }

    @Override
    public void setParticleCount(int particleCount) {
        particleCount = Math.max(particleCount, 1);
        this.setParticleDensity(this.end.clone().subtract(this.start).length() / (double)particleCount);
        this.setNeedsUpdate(true);
    }

    @Override
    public double getLength() {
        return this.start.clone().subtract(this.end).length();
    }

    @Override
    public void setLength(double length) {
        length = Math.max(length, 1.0E-4);
        Vector direction = this.end.clone().subtract(this.start).normalize();
        this.end = this.start.clone().add(direction.multiply(length));
    }

    @Override
    public double getWidth() {
        return 0.0;
    }

    @Override
    public void setWidth(double width) {
    }

    @Override
    public double getHeight() {
        return 0.0;
    }

    @Override
    public void setHeight(double height) {
    }

    @Override
    @Contract(value="-> new")
    public Shape clone() {
        Line line;
        if (this.isDynamic) {
            assert (this.startLocation != null);
            assert (this.endLocation != null);
            line = new Line(this.startLocation, this.endLocation);
        } else {
            line = new Line(this.start, this.end);
        }
        line.isDynamic = this.isDynamic;
        return this.copyTo(line);
    }

    public String toString() {
        return "Line from " + this.start + " to " + this.end;
    }
}

