/*
 * Decompiled with CFR 0.152.
 */
package com.sovdee.skriptparticles.shapes;

import com.sovdee.skriptparticles.shapes.AbstractShape;
import com.sovdee.skriptparticles.shapes.LWHShape;
import com.sovdee.skriptparticles.shapes.Shape;
import com.sovdee.skriptparticles.util.DynamicLocation;
import com.sovdee.skriptparticles.util.Quaternion;
import java.util.Set;
import org.bukkit.Location;
import org.bukkit.util.Vector;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.jetbrains.annotations.Contract;

public class Rectangle
extends AbstractShape
implements LWHShape {
    private Plane plane;
    private double halfLength;
    private double halfWidth;
    private double lengthStep = 1.0;
    private double widthStep = 1.0;
    private Vector centerOffset = new Vector(0, 0, 0);
    private @Nullable DynamicLocation negativeCorner;
    private @Nullable DynamicLocation positiveCorner;
    private boolean isDynamic = false;

    public Rectangle(double length, double width, Plane plane) {
        this.plane = plane;
        this.halfLength = Math.max(length / 2.0, 1.0E-4);
        this.halfWidth = Math.max(width / 2.0, 1.0E-4);
        this.calculateSteps();
    }

    public Rectangle(Vector cornerA, Vector cornerB, Plane plane) {
        if (cornerA.equals((Object)cornerB)) {
            throw new IllegalArgumentException("Corners cannot be the same.");
        }
        this.plane = plane;
        this.setLengthWidth(cornerA, cornerB);
        this.centerOffset = cornerB.clone().add(cornerA).multiply(0.5);
        switch (plane) {
            case XZ: {
                this.centerOffset.setY(0);
                break;
            }
            case XY: {
                this.centerOffset.setZ(0);
                break;
            }
            case YZ: {
                this.centerOffset.setX(0);
            }
        }
        this.calculateSteps();
    }

    public Rectangle(DynamicLocation cornerA, DynamicLocation cornerB, Plane plane) {
        if (cornerA.equals(cornerB)) {
            throw new IllegalArgumentException("Corners cannot be the same.");
        }
        this.plane = plane;
        Location cornerALocation = cornerA.getLocation();
        Location cornerBLocation = cornerB.getLocation();
        if (cornerA.equals(cornerB)) {
            throw new IllegalArgumentException("Corners cannot be the same.");
        }
        if (cornerA.isDynamic() || cornerB.isDynamic()) {
            this.negativeCorner = cornerA.clone();
            this.positiveCorner = cornerB.clone();
            this.isDynamic = true;
        } else {
            this.setLengthWidth(cornerALocation, cornerBLocation);
        }
        Vector offset = cornerBLocation.toVector().subtract(cornerALocation.toVector()).multiply(0.5);
        switch (plane) {
            case XZ: {
                offset.setY(0);
                break;
            }
            case XY: {
                offset.setZ(0);
                break;
            }
            case YZ: {
                offset.setX(0);
            }
        }
        this.setLocation(new DynamicLocation(cornerALocation.clone().add(offset)));
        this.calculateSteps();
    }

    private void setLengthWidth(Location cornerA, Location cornerB) {
        this.setLengthWidth(cornerA.toVector(), cornerB.toVector());
    }

    private void setLengthWidth(Vector cornerA, Vector cornerB) {
        double length = switch (this.plane) {
            default -> throw new IncompatibleClassChangeError();
            case Plane.XZ, Plane.XY -> Math.abs(cornerA.getX() - cornerB.getX());
            case Plane.YZ -> Math.abs(cornerA.getY() - cornerB.getY());
        };
        double width = switch (this.plane) {
            default -> throw new IncompatibleClassChangeError();
            case Plane.XZ, Plane.YZ -> Math.abs(cornerA.getZ() - cornerB.getZ());
            case Plane.XY -> Math.abs(cornerA.getY() - cornerB.getY());
        };
        this.halfWidth = Math.abs(width) / 2.0;
        this.halfLength = Math.abs(length) / 2.0;
    }

    @Contract(pure=true, value="_, _ -> new")
    private Vector vectorFromLengthWidth(double length, double width) {
        return switch (this.plane) {
            default -> throw new IncompatibleClassChangeError();
            case Plane.XZ -> new Vector(length, 0.0, width);
            case Plane.XY -> new Vector(length, width, 0.0);
            case Plane.YZ -> new Vector(0.0, length, width);
        };
    }

    private void calculateSteps() {
        double particleDensity = this.getParticleDensity();
        this.lengthStep = 2.0 * this.halfWidth / (double)Math.round(2.0 * this.halfWidth / particleDensity);
        this.widthStep = 2.0 * this.halfLength / (double)Math.round(2.0 * this.halfLength / particleDensity);
    }

    @Override
    @Contract(pure=true)
    public void generateOutline(Set<Vector> points) {
        for (double l = -this.halfLength + this.widthStep; l < this.halfLength; l += this.widthStep) {
            points.add(this.vectorFromLengthWidth(l, -this.halfWidth));
            points.add(this.vectorFromLengthWidth(l, this.halfWidth));
        }
        for (double w = -this.halfWidth; w <= this.halfWidth; w += this.lengthStep) {
            points.add(this.vectorFromLengthWidth(-this.halfLength, w));
            points.add(this.vectorFromLengthWidth(this.halfLength, w));
        }
    }

    @Override
    @Contract(pure=true)
    public void generateSurface(Set<Vector> points) {
        for (double w = -this.halfWidth; w <= this.halfWidth; w += this.lengthStep) {
            for (double l = -this.halfLength; l <= this.halfLength; l += this.widthStep) {
                points.add(this.vectorFromLengthWidth(l, w));
            }
        }
    }

    @Override
    @Contract(pure=true)
    public void generatePoints(Set<Vector> points) {
        if (this.isDynamic) {
            assert (this.positiveCorner != null);
            assert (this.negativeCorner != null);
            Location pos = this.positiveCorner.getLocation();
            Location neg = this.negativeCorner.getLocation();
            this.setLengthWidth(neg, pos);
            Vector offset = pos.toVector().subtract(neg.toVector()).multiply(0.5);
            switch (this.plane) {
                case XZ: {
                    offset.setY(0);
                    break;
                }
                case XY: {
                    offset.setZ(0);
                    break;
                }
                case YZ: {
                    offset.setX(0);
                }
            }
            this.setLocation(new DynamicLocation(neg.clone().add(offset)));
        }
        this.calculateSteps();
        super.generatePoints(points);
        points.forEach(vector -> vector.add(this.centerOffset));
    }

    @Override
    public Set<Vector> getPoints(Quaternion orientation) {
        Set<Vector> points = super.getPoints(orientation);
        if (this.isDynamic) {
            this.setNeedsUpdate(true);
        }
        return points;
    }

    @Override
    public void setParticleCount(int particleCount) {
        particleCount = Math.max(particleCount, 1);
        switch (this.getStyle()) {
            case FILL: 
            case SURFACE: {
                this.setParticleDensity(Math.sqrt(4.0 * this.halfWidth * this.halfLength / (double)particleCount));
                break;
            }
            case OUTLINE: {
                this.setParticleDensity(4.0 * (this.halfWidth + this.halfLength) / (double)particleCount);
            }
        }
        this.setNeedsUpdate(true);
    }

    @Override
    public double getLength() {
        return this.halfLength * 2.0;
    }

    @Override
    public void setLength(double length) {
        this.halfLength = Math.max(length / 2.0, 1.0E-4);
        this.setNeedsUpdate(true);
    }

    @Override
    public double getWidth() {
        return this.halfWidth * 2.0;
    }

    @Override
    public void setWidth(double width) {
        this.halfWidth = Math.max(width / 2.0, 1.0E-4);
        this.setNeedsUpdate(true);
    }

    @Override
    public double getHeight() {
        return 0.0;
    }

    @Override
    public void setHeight(double height) {
    }

    public Plane getPlane() {
        return this.plane;
    }

    public void setPlane(Plane plane) {
        this.plane = plane;
        this.setNeedsUpdate(true);
    }

    @Override
    @Contract(value="-> new")
    public Shape clone() {
        Rectangle rectangle;
        if (this.isDynamic) {
            assert (this.negativeCorner != null);
            assert (this.positiveCorner != null);
            rectangle = new Rectangle(this.negativeCorner, this.positiveCorner, this.plane);
        } else {
            rectangle = new Rectangle(this.getLength(), this.getWidth(), this.plane);
        }
        rectangle.isDynamic = this.isDynamic;
        return this.copyTo(rectangle);
    }

    public String toString() {
        String axis = this.plane.toString().toLowerCase();
        if (this.isDynamic) {
            return axis + " rectangle from " + this.negativeCorner + " to " + this.positiveCorner;
        }
        return axis + " rectangle with length " + this.getLength() + " and width " + this.getWidth();
    }

    public static enum Plane {
        XZ,
        XY,
        YZ;

    }
}

