/*
 * Decompiled with CFR 0.152.
 */
package com.sovdee.skriptparticles.shapes;

import com.sovdee.skriptparticles.shapes.AbstractShape;
import com.sovdee.skriptparticles.shapes.LWHShape;
import com.sovdee.skriptparticles.shapes.PolyShape;
import com.sovdee.skriptparticles.shapes.RadialShape;
import com.sovdee.skriptparticles.shapes.Shape;
import com.sovdee.skriptparticles.util.MathUtil;
import java.util.Set;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.Contract;

public class RegularPolygon
extends AbstractShape
implements PolyShape,
RadialShape,
LWHShape {
    private double angle;
    private double radius;
    private double height;

    public RegularPolygon(int sides, double radius) {
        this(Math.PI * 2 / (double)sides, radius, 0.0);
    }

    public RegularPolygon(double angle, double radius) {
        this(angle, radius, 0.0);
    }

    public RegularPolygon(int sides, double radius, double height) {
        this(Math.PI * 2 / (double)sides, radius, height);
    }

    public RegularPolygon(double angle, double radius, double height) {
        this.angle = MathUtil.clamp(angle, 1.0E-4, 2.0943951023931953);
        this.radius = Math.max(radius, 1.0E-4);
        this.height = Math.max(height, 0.0);
    }

    @Override
    @Contract(pure=true)
    public void generateOutline(Set<Vector> points) {
        if (this.height == 0.0) {
            points.addAll(MathUtil.calculateRegularPolygon(this.radius, this.angle, this.getParticleDensity(), true));
        } else {
            points.addAll(MathUtil.calculateRegularPrism(this.radius, this.angle, this.height, this.getParticleDensity(), true));
        }
    }

    @Override
    @Contract(pure=true)
    public void generateSurface(Set<Vector> points) {
        if (this.height == 0.0) {
            points.addAll(MathUtil.calculateRegularPolygon(this.radius, this.angle, this.getParticleDensity(), false));
        } else {
            points.addAll(MathUtil.calculateRegularPrism(this.radius, this.angle, this.height, this.getParticleDensity(), false));
        }
    }

    @Override
    public void generateFilled(Set<Vector> points) {
        if (this.height == 0.0) {
            this.generateSurface(points);
        } else {
            double particleDensity = this.getParticleDensity();
            Set<Vector> polygon = MathUtil.calculateRegularPolygon(this.radius, this.angle, particleDensity, false);
            points.addAll(MathUtil.fillVertically(polygon, this.height, particleDensity));
        }
    }

    @Override
    public void setParticleCount(int particleCount) {
        particleCount = Math.max(particleCount, 1);
        int sides = this.getSides();
        this.setParticleDensity(switch (this.getStyle()) {
            default -> throw new IncompatibleClassChangeError();
            case Shape.Style.OUTLINE -> {
                if (this.height == 0.0) {
                    yield (double)(2 * sides) * this.radius * Math.sin(this.angle / 2.0) / (double)particleCount;
                }
                yield ((double)(4 * sides) * this.radius * Math.sin(this.angle / 2.0) + this.height * (double)sides) / (double)particleCount;
            }
            case Shape.Style.SURFACE -> {
                if (this.height == 0.0) {
                    yield Math.sqrt((double)sides * this.radius * this.radius * Math.sin(this.angle) / 2.0 / (double)particleCount);
                }
                yield ((double)sides * this.radius * this.radius * Math.sin(this.angle) + this.getSideLength() * (double)sides * this.height) / (double)particleCount;
            }
            case Shape.Style.FILL -> (double)sides * this.radius * this.radius * Math.sin(this.angle) * this.height / (double)particleCount;
        });
        this.setNeedsUpdate(true);
    }

    @Override
    public int getSides() {
        return (int)(Math.PI * 2 / this.angle);
    }

    @Override
    public void setSides(int sides) {
        this.angle = Math.PI * 2 / (double)Math.max(sides, 3);
        this.setNeedsUpdate(true);
    }

    @Override
    public double getSideLength() {
        return this.radius * 2.0 * Math.sin(this.angle / 2.0);
    }

    @Override
    public void setSideLength(double sideLength) {
        sideLength = Math.max(sideLength, 1.0E-4);
        this.radius = sideLength / (2.0 * Math.sin(this.angle / 2.0));
        this.radius = Math.max(this.radius, 1.0E-4);
        this.setNeedsUpdate(true);
    }

    @Override
    public double getRadius() {
        return this.radius;
    }

    @Override
    public void setRadius(double radius) {
        this.radius = Math.max(radius, 1.0E-4);
        this.setNeedsUpdate(true);
    }

    @Override
    public double getLength() {
        return 0.0;
    }

    @Override
    public void setLength(double length) {
    }

    @Override
    public double getWidth() {
        return 0.0;
    }

    @Override
    public void setWidth(double width) {
    }

    @Override
    public double getHeight() {
        return this.height;
    }

    @Override
    public void setHeight(double height) {
        this.height = Math.max(height, 0.0);
        this.setNeedsUpdate(true);
    }

    @Override
    @Contract(value="-> new")
    public Shape clone() {
        return this.copyTo(new RegularPolygon(this.angle, this.radius, this.height));
    }

    public String toString() {
        return "regular polygon with " + this.getSides() + " sides and radius " + this.getRadius();
    }
}

