/*
 * Decompiled with CFR 0.152.
 */
package com.sovdee.skriptparticles.shapes;

import com.sovdee.skriptparticles.shapes.AbstractShape;
import com.sovdee.skriptparticles.shapes.PolyShape;
import com.sovdee.skriptparticles.shapes.RadialShape;
import com.sovdee.skriptparticles.shapes.Shape;
import com.sovdee.skriptparticles.util.MathUtil;
import com.sovdee.skriptparticles.util.Quaternion;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.Contract;

public class RegularPolyhedron
extends AbstractShape
implements RadialShape,
PolyShape {
    private static final Quaternion[] TETRAHEDRON_FACES = new Quaternion[]{new Quaternion(1.0, 0.0, 0.0, 0.0), new Quaternion(-0.5, -0.0, -0.288675134594813, 0.816496580927726), new Quaternion(0.5, 0.0, -0.288675134594813, 0.816496580927726), new Quaternion(0.0, 0.0, 0.5773502691896258, 0.816496580927726)};
    private static final Quaternion[] OCTAHEDRON_FACES = new Quaternion[]{new Quaternion(0.0, 0.0, 0.45970084338098305, 0.8880738339771153), new Quaternion(0.3250575836718681, 0.6279630301995544, 0.32505758367186816, 0.6279630301995545), new Quaternion(0.45970084338098305, 0.8880738339771153, 0.0, 0.0), new Quaternion(0.32505758367186816, 0.6279630301995545, -0.3250575836718681, -0.6279630301995544), new Quaternion(0.0, 0.0, 0.8880738339771153, -0.45970084338098316), new Quaternion(0.6279630301995544, -0.3250575836718682, 0.6279630301995545, -0.3250575836718682), new Quaternion(0.8880738339771153, -0.45970084338098316, 0.0, 0.0), new Quaternion(0.6279630301995545, -0.3250575836718682, -0.6279630301995544, 0.3250575836718682)};
    private static final Quaternion[] ICOSAHEDRON_FACES = new Quaternion[]{new Quaternion(1.0, 0.0, 0.0, 0.0), new Quaternion(0.0, 1.0, 0.0, 0.0), new Quaternion(0.3090169943749475, 0.0, 0.17841104488654494, 0.9341723589627158), new Quaternion(-0.5, 0.8090169943749475, 0.288675134594813, 0.110264089708268), new Quaternion(0.0, 0.8090169943749475, 0.5773502691896256, -0.110264089708268), new Quaternion(0.3090169943749475, 0.0, -0.1784110448865451, -0.9341723589627157), new Quaternion(0.5, -0.8090169943749475, 0.288675134594813, 0.110264089708268), new Quaternion(0.0, 0.8090169943749475, -0.5773502691896261, 0.110264089708268), new Quaternion(0.0, 0.0, 0.35682208977309, -0.9341723589627157), new Quaternion(-0.5, -0.8090169943749475, -0.288675134594813, -0.110264089708268), new Quaternion(0.5, 0.8090169943749475, -0.288675134594813, -0.110264089708268), new Quaternion(-0.8090169943749475, -0.0, -0.46708617948135794, 0.35682208977309), new Quaternion(0.3090169943749475, 0.5, -0.7557613140761709, -0.288675134594813), new Quaternion(0.8090169943749475, 0.0, -0.46708617948135794, 0.35682208977309), new Quaternion(-0.5, -0.5, -0.6454972243679027, 0.288675134594813), new Quaternion(0.0, 0.0, 0.9341723589627157, 0.35682208977309), new Quaternion(-0.8090169943749475, 0.5, 0.110264089708268, -0.288675134594813)};
    private static final Quaternion[] DODECAHEDRON_FACES = new Quaternion[]{new Quaternion(0.0, 0.3090169943749475, 0.0, 0.9510565162951536), new Quaternion(-0.3090169943749475, 0.0, 0.9510565162951536, 0.0), new Quaternion(0.0, 0.0, 0.8506508083520399, 0.5257311121191337), new Quaternion(0.0, 0.0, 0.5257311121191337, -0.8506508083520399), new Quaternion(0.5, 0.3090169943749475, 0.6881909602355868, 0.42532540417602), new Quaternion(0.3090169943749475, -0.5, 0.42532540417602, -0.6881909602355868), new Quaternion(0.8090169943749475, 0.5, 0.2628655560595668, 0.1624598481164532), new Quaternion(0.5, -0.8090169943749475, 0.1624598481164532, -0.2628655560595668), new Quaternion(0.8090169943749475, 0.5, -0.2628655560595668, -0.1624598481164532), new Quaternion(0.5, -0.8090169943749475, -0.1624598481164532, 0.2628655560595668), new Quaternion(0.5, 0.3090169943749475, -0.6881909602355868, -0.42532540417602), new Quaternion(0.3090169943749475, -0.5, -0.42532540417602, 0.6881909602355868)};
    private double radius;
    private int faces;

    public RegularPolyhedron(double radius, int faces) {
        this.radius = Math.max(radius, 1.0E-4);
        this.faces = switch (faces) {
            case 4, 8, 12, 20 -> faces;
            default -> 4;
        };
    }

    @Override
    @Contract(pure=true)
    public void generateOutline(Set<Vector> points) {
        points.addAll(switch (this.faces) {
            case 4 -> this.generatePolyhedron(TETRAHEDRON_FACES, this.radius);
            case 8 -> this.generatePolyhedron(OCTAHEDRON_FACES, this.radius);
            case 20 -> this.generatePolyhedron(ICOSAHEDRON_FACES, this.radius);
            case 12 -> this.generatePolyhedron(DODECAHEDRON_FACES, this.radius);
            default -> new HashSet();
        });
    }

    @Override
    public void generateFilled(Set<Vector> points) {
        double step = this.radius / (double)Math.round(this.radius / this.getParticleDensity());
        switch (this.faces) {
            case 4: {
                for (double i = this.radius; i > 0.0; i -= step) {
                    points.addAll(this.generatePolyhedron(TETRAHEDRON_FACES, i));
                }
                break;
            }
            case 8: {
                for (double i = this.radius; i > 0.0; i -= step) {
                    points.addAll(this.generatePolyhedron(OCTAHEDRON_FACES, i));
                }
                break;
            }
            case 12: {
                for (double i = this.radius; i > 0.0; i -= step) {
                    points.addAll(this.generatePolyhedron(DODECAHEDRON_FACES, i));
                }
                break;
            }
            case 20: {
                for (double i = this.radius; i > 0.0; i -= step) {
                    points.addAll(this.generatePolyhedron(ICOSAHEDRON_FACES, i));
                }
                break;
            }
        }
    }

    @Contract(pure=true, value="_, _ -> new")
    private Set<Vector> generatePolyhedron(Quaternion[] rotations, double radius) {
        LinkedHashSet<Vector> points = new LinkedHashSet<Vector>();
        int sides = this.faces == 12 ? 5 : 3;
        double sideLength = switch (this.faces) {
            case 4 -> radius / 0.6123724356957945;
            case 8 -> radius / 0.7071067811865;
            case 12 -> radius / 1.401258538;
            case 20 -> radius / 0.9510565162951535;
            default -> 0.0;
        };
        double inscribedRadius = switch (this.faces) {
            case 4 -> sideLength / 4.89897948556;
            case 8 -> sideLength * 0.40824829;
            case 12 -> sideLength * 1.113516364;
            case 20 -> sideLength * 0.7557613141;
            default -> 1.0;
        };
        Vector offset = new Vector(0.0, inscribedRadius, 0.0);
        double faceRadius = sideLength / (2.0 * Math.sin(Math.PI / (double)sides));
        Shape.Style style = this.getStyle();
        for (Quaternion rotation : rotations) {
            LinkedHashSet<Vector> facePoints = new LinkedHashSet<Vector>(switch (style) {
                default -> throw new IncompatibleClassChangeError();
                case Shape.Style.OUTLINE -> this.generateFaceOutline(sides, faceRadius);
                case Shape.Style.FILL, Shape.Style.SURFACE -> this.generateFaceSurface(sides, faceRadius);
            });
            facePoints.forEach(point -> rotation.transform(point.add(offset)));
            points.addAll(facePoints);
        }
        return points;
    }

    @Contract(pure=true, value="_, _ -> new")
    private Set<Vector> generateFaceOutline(int sides, double radius) {
        return new LinkedHashSet<Vector>(MathUtil.calculateRegularPolygon(radius, Math.PI * 2 / (double)sides, this.getParticleDensity(), true));
    }

    @Contract(pure=true, value="_, _ -> new")
    private Set<Vector> generateFaceSurface(int sides, double radius) {
        LinkedHashSet<Vector> facePoints = new LinkedHashSet<Vector>();
        double particleDensity = this.getParticleDensity();
        double apothem = radius * Math.cos(Math.PI / (double)sides);
        double radiusStep = radius / (double)Math.round(apothem / particleDensity);
        for (double subRadius = radius; subRadius > 0.0; subRadius -= radiusStep) {
            facePoints.addAll(MathUtil.calculateRegularPolygon(subRadius, Math.PI * 2 / (double)sides, particleDensity, false));
        }
        facePoints.add(new Vector(0, 0, 0));
        return facePoints;
    }

    @Override
    public void setParticleCount(int particleCount) {
    }

    @Override
    @Contract(value="-> new")
    public Shape clone() {
        return this.copyTo(new RegularPolyhedron(this.radius, this.faces));
    }

    @Override
    public int getSides() {
        return this.faces;
    }

    @Override
    public void setSides(int sides) {
        switch (sides) {
            case 4: 
            case 8: 
            case 12: 
            case 20: {
                this.faces = sides;
                break;
            }
            default: {
                return;
            }
        }
        this.setNeedsUpdate(true);
    }

    @Override
    public double getSideLength() {
        return switch (this.faces) {
            case 4 -> this.radius / 0.6123724356957945;
            case 8 -> this.radius / 0.7071067811865;
            case 12 -> this.radius / 1.401258538;
            case 20 -> this.radius / 0.9510565162951535;
            default -> 0.0;
        };
    }

    @Override
    public void setSideLength(double sideLength) {
        sideLength = Math.max(sideLength, 1.0E-4);
        switch (this.faces) {
            case 4: {
                this.radius = sideLength * 0.6123724356957945;
                break;
            }
            case 8: {
                this.radius = sideLength * 0.7071067811865;
                break;
            }
            case 12: {
                this.radius = sideLength * 1.401258538;
                break;
            }
            case 20: {
                this.radius = sideLength * 0.9510565162951535;
                break;
            }
            default: {
                return;
            }
        }
        this.setNeedsUpdate(true);
    }

    @Override
    public double getRadius() {
        return this.radius;
    }

    @Override
    public void setRadius(double radius) {
        this.radius = Math.max(radius, 1.0E-4);
        this.setNeedsUpdate(true);
    }
}

