/*
 * Decompiled with CFR 0.152.
 */
package com.sovdee.skriptparticles.shapes;

import com.sovdee.skriptparticles.particles.Particle;
import com.sovdee.skriptparticles.util.DynamicLocation;
import com.sovdee.skriptparticles.util.Quaternion;
import java.util.Collection;
import java.util.Comparator;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.bukkit.entity.Player;
import org.bukkit.util.Vector;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.RequiresNonNull;
import org.jetbrains.annotations.Contract;
import org.joml.Quaternionf;

public interface Shape
extends Cloneable {
    public Set<Vector> getPoints();

    public void setPoints(Set<Vector> var1);

    public Set<Vector> getPoints(Quaternion var1);

    @Contract(pure=true)
    default public void generatePoints(Set<Vector> points) {
        this.getStyle().generatePoints(this, points);
    }

    @Contract(pure=true)
    public void generateOutline(Set<Vector> var1);

    @Contract(pure=true)
    public void generateSurface(Set<Vector> var1);

    @Contract(pure=true)
    public void generateFilled(Set<Vector> var1);

    @RequiresNonNull(value={"location"})
    public void draw(Collection<Player> var1);

    public void draw(DynamicLocation var1, Collection<Player> var2);

    public void draw(DynamicLocation var1, Quaternion var2, Particle var3, Collection<Player> var4);

    public void draw(DynamicLocation var1, Consumer<Shape> var2, Collection<Player> var3);

    public Vector getRelativeXAxis(boolean var1);

    public Vector getRelativeYAxis(boolean var1);

    public Vector getRelativeZAxis(boolean var1);

    public void showLocalAxes(boolean var1);

    public boolean showLocalAxes();

    public void showGlobalAxes(boolean var1);

    public boolean showGlobalAxes();

    public @Nullable DynamicLocation getLastLocation();

    public Style getStyle();

    public void setStyle(Style var1);

    public Quaternion getOrientation();

    public void setOrientation(Quaternionf var1);

    public double getScale();

    public void setScale(double var1);

    public Vector getOffset();

    public void setOffset(Vector var1);

    public @Nullable DynamicLocation getLocation();

    public void setLocation(DynamicLocation var1);

    public UUID getUUID();

    public Particle getParticle();

    public void setParticle(Particle var1);

    public @Nullable Comparator<Vector> getOrdering();

    public void setOrdering(@Nullable Comparator<Vector> var1);

    public double getParticleDensity();

    public void setParticleDensity(double var1);

    public int getParticleCount();

    public void setParticleCount(int var1);

    public boolean needsUpdate();

    public void setNeedsUpdate(boolean var1);

    public long getAnimationDuration();

    public void setAnimationDuration(long var1);

    @Contract(value="-> new")
    public Shape clone();

    @Contract(value="_ -> param1")
    public Shape copyTo(Shape var1);

    @Contract(value="-> new")
    public State getState();

    @Contract(value="_ -> new")
    public State getState(Quaternion var1);

    public void setLastState(State var1);

    public static enum Style {
        OUTLINE((shape, points) -> shape.generateOutline((Set<Vector>)points)),
        SURFACE((shape, points) -> shape.generateSurface((Set<Vector>)points)),
        FILL((shape, points) -> shape.generateFilled((Set<Vector>)points));

        private final BiConsumer<Shape, Set<Vector>> generatePoints;

        private Style(BiConsumer<Shape, Set<Vector>> generatePoints) {
            this.generatePoints = generatePoints;
        }

        public void generatePoints(Shape shape, Set<Vector> points) {
            this.generatePoints.accept(shape, points);
        }

        public String toString() {
            return this.name().toLowerCase();
        }
    }

    public record State(Style style, int orientationHash, double scale, int offsetHash, double particleDensity) {
        public boolean equals(State state) {
            return state.style() == this.style && state.orientationHash() == this.orientationHash && state.scale() == this.scale && state.offsetHash() == this.offsetHash && state.particleDensity() == this.particleDensity;
        }
    }
}

