/*
 * Decompiled with CFR 0.152.
 */
package com.sovdee.skriptparticles.shapes;

import com.sovdee.skriptparticles.shapes.AbstractShape;
import com.sovdee.skriptparticles.shapes.RadialShape;
import com.sovdee.skriptparticles.shapes.Shape;
import com.sovdee.skriptparticles.util.MathUtil;
import java.util.Set;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.Contract;

public class Sphere
extends AbstractShape
implements RadialShape {
    private double radius;
    protected double cutoffAngle;
    protected double cutoffAngleCos;

    public Sphere(double radius) {
        this.radius = Math.max(radius, 1.0E-4);
        this.cutoffAngle = Math.PI;
        this.cutoffAngleCos = -1.0;
        this.setStyle(Shape.Style.SURFACE);
    }

    @Override
    @Contract(pure=true)
    public void generateOutline(Set<Vector> points) {
        this.generateSurface(points);
    }

    @Override
    @Contract(pure=true)
    public void generateSurface(Set<Vector> points) {
        double particleDensity = this.getParticleDensity();
        int pointCount = 4 * (int)(Math.PI * this.radius * this.radius / (particleDensity * particleDensity));
        points.addAll(MathUtil.calculateFibonacciSphere(pointCount, this.radius, this.cutoffAngle));
    }

    @Override
    @Contract(pure=true)
    public void generateFilled(Set<Vector> points) {
        double particleDensity = this.getParticleDensity();
        int subSpheres = (int)(this.radius / particleDensity) - 1;
        double radiusStep = this.radius / (double)subSpheres;
        for (int i = 1; i < subSpheres; ++i) {
            double subRadius = (double)i * radiusStep;
            int pointCount = 4 * (int)(Math.PI * subRadius * subRadius / (particleDensity * particleDensity));
            points.addAll(MathUtil.calculateFibonacciSphere(pointCount, subRadius, this.cutoffAngle));
        }
    }

    @Override
    public void setParticleCount(int particleCount) {
        particleCount = Math.max(particleCount, 1);
        this.setParticleDensity(switch (this.getStyle()) {
            default -> throw new IncompatibleClassChangeError();
            case Shape.Style.OUTLINE, Shape.Style.SURFACE -> Math.sqrt(Math.PI * 2 * this.radius * this.radius * (1.0 - this.cutoffAngleCos) / (double)particleCount);
            case Shape.Style.FILL -> Math.cbrt(1.0471975511965976 * this.radius * this.radius * this.radius * (2.0 + this.cutoffAngleCos) * (1.0 - this.cutoffAngleCos) * (1.0 - this.cutoffAngleCos) / (double)particleCount);
        });
        this.setNeedsUpdate(true);
    }

    @Override
    public double getRadius() {
        return this.radius;
    }

    @Override
    public void setRadius(double radius) {
        this.radius = Math.max(radius, 1.0E-4);
        this.setNeedsUpdate(true);
    }

    @Override
    @Contract(value="-> new")
    public Shape clone() {
        return this.copyTo(new Sphere(this.radius));
    }

    public String toString() {
        return this.getStyle() + " sphere with radius " + this.radius;
    }
}

