/*
 * Decompiled with CFR 0.152.
 */
package com.sovdee.skriptparticles.shapes;

import com.sovdee.skriptparticles.shapes.CutoffShape;
import com.sovdee.skriptparticles.shapes.Shape;
import com.sovdee.skriptparticles.shapes.Sphere;
import com.sovdee.skriptparticles.util.MathUtil;
import org.jetbrains.annotations.Contract;

public class SphericalCap
extends Sphere
implements CutoffShape {
    public SphericalCap(double radius, double cutoffAngle) {
        super(radius);
        this.cutoffAngle = MathUtil.clamp(cutoffAngle, 0.0, Math.PI);
        this.cutoffAngleCos = Math.cos(this.cutoffAngle);
    }

    @Override
    public double getCutoffAngle() {
        return this.cutoffAngle;
    }

    @Override
    public void setCutoffAngle(double cutoffAngle) {
        this.cutoffAngle = MathUtil.clamp(cutoffAngle, 0.0, Math.PI);
        this.cutoffAngleCos = Math.cos(this.cutoffAngle);
        this.setNeedsUpdate(true);
    }

    @Override
    @Contract(value="-> new")
    public Shape clone() {
        return this.copyTo(new SphericalCap(this.getRadius(), this.cutoffAngle));
    }
}

