/*
 * Decompiled with CFR 0.152.
 */
package com.sovdee.skriptparticles.shapes;

import com.sovdee.skriptparticles.shapes.AbstractShape;
import com.sovdee.skriptparticles.shapes.Shape;
import com.sovdee.skriptparticles.util.MathUtil;
import java.util.Set;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.Contract;

public class Star
extends AbstractShape {
    private double innerRadius;
    private double outerRadius;
    private double angle;

    public Star(double innerRadius, double outerRadius, double angle) {
        this.innerRadius = Math.max(innerRadius, 1.0E-4);
        this.outerRadius = Math.max(outerRadius, 1.0E-4);
        this.angle = MathUtil.clamp(angle, 1.0E-4, Math.PI);
    }

    @Override
    @Contract(pure=true)
    public void generateOutline(Set<Vector> points) {
        points.addAll(MathUtil.calculateStar(this.innerRadius, this.outerRadius, this.angle, this.getParticleDensity()));
    }

    @Override
    @Contract(pure=true)
    public void generateSurface(Set<Vector> points) {
        double minRadius = Math.min(this.innerRadius, this.outerRadius);
        double particleDensity = this.getParticleDensity();
        for (double r = 0.0; r < minRadius; r += particleDensity) {
            points.addAll(MathUtil.calculateStar(this.innerRadius - r, this.outerRadius - r, this.angle, particleDensity));
        }
    }

    @Override
    public void setParticleCount(int particleCount) {
        particleCount = Math.max(particleCount, 1);
        double sideLength = Math.sqrt(Math.pow(this.innerRadius, 2.0) + Math.pow(this.outerRadius, 2.0) - 2.0 * this.innerRadius * this.outerRadius * Math.cos(this.angle));
        double perimeter = sideLength * (double)this.getStarPoints() * 2.0;
        this.setParticleDensity(perimeter / (double)particleCount);
    }

    public double getInnerRadius() {
        return this.innerRadius;
    }

    public void setInnerRadius(double innerRadius) {
        this.innerRadius = Math.max(innerRadius, 1.0E-4);
        this.setNeedsUpdate(true);
    }

    public double getOuterRadius() {
        return this.outerRadius;
    }

    public void setOuterRadius(double outerRadius) {
        this.outerRadius = Math.max(outerRadius, 1.0E-4);
        this.setNeedsUpdate(true);
    }

    public int getStarPoints() {
        return (int)(Math.PI * 2 / this.angle);
    }

    public void setStarPoints(int starPoints) {
        starPoints = Math.max(starPoints, 2);
        this.angle = Math.PI * 2 / (double)starPoints;
        this.setNeedsUpdate(true);
    }

    @Override
    @Contract(value="-> new")
    public Shape clone() {
        return this.copyTo(new Star(this.innerRadius, this.outerRadius, this.angle));
    }
}

