/*
 * Decompiled with CFR 0.152.
 */
package com.sovdee.skriptparticles.util;

import ch.njol.skript.util.Direction;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.jetbrains.annotations.Contract;

public class DynamicLocation {
    private @Nullable Entity entity;
    private @Nullable Location location;
    private @Nullable Direction direction;

    public DynamicLocation(Entity entity) {
        this.entity = entity;
    }

    public DynamicLocation(Location location) {
        this.location = location.clone();
    }

    public DynamicLocation(Location location, @Nullable Direction direction) {
        this.location = location.clone();
        this.direction = direction;
    }

    public DynamicLocation(Entity entity, @Nullable Direction direction) {
        this.entity = entity;
        this.direction = direction;
    }

    public DynamicLocation(DynamicLocation dynamicLocation) {
        this.entity = dynamicLocation.getEntity();
        this.direction = dynamicLocation.getDirection();
        this.location = dynamicLocation.getLocation();
    }

    public DynamicLocation() {
        this.location = null;
        this.entity = null;
        this.direction = null;
    }

    public static @Nullable DynamicLocation fromLocationEntity(Object locationEntity) {
        if (locationEntity instanceof Location) {
            Location location = (Location)locationEntity;
            return new DynamicLocation(location);
        }
        if (locationEntity instanceof Entity) {
            Entity entity = (Entity)locationEntity;
            return new DynamicLocation(entity);
        }
        return null;
    }

    public Location getLocation() {
        @Nullable Location location = this.location;
        if (this.entity != null) {
            location = this.entity.getLocation();
        }
        if (this.direction != null && location != null) {
            location = this.direction.getRelative(location);
        }
        return location == null ? new Location(null, 0.0, 0.0, 0.0) : location.clone();
    }

    public void setLocation(Location location) {
        this.location = location;
        this.entity = null;
    }

    public @Nullable Entity getEntity() {
        return this.entity;
    }

    public void setEntity(Entity entity) {
        this.entity = entity;
        this.location = null;
    }

    public @Nullable Direction getDirection() {
        return this.direction;
    }

    public void setDirection(Direction direction) {
        this.direction = direction;
    }

    public boolean isDynamic() {
        return this.entity != null;
    }

    @Contract(value=" -> new", pure=true)
    public DynamicLocation clone() {
        return new DynamicLocation(this);
    }

    public boolean equals(Object obj) {
        boolean matchingDirection;
        if (!(obj instanceof DynamicLocation)) {
            return false;
        }
        DynamicLocation dynamicLocation = (DynamicLocation)obj;
        boolean matchingEntity = this.entity != null && dynamicLocation.entity != null && this.entity.equals(dynamicLocation.entity);
        boolean matchingLocation = this.location != null && dynamicLocation.location != null && this.location.equals((Object)dynamicLocation.location);
        boolean bl = matchingDirection = this.direction != null && dynamicLocation.direction != null && this.direction.equals((Object)dynamicLocation.direction);
        if (matchingEntity || matchingLocation) {
            return matchingDirection || this.direction == null && dynamicLocation.direction == null;
        }
        return false;
    }

    public String toString() {
        if (this.entity != null) {
            return this.entity.toString();
        }
        if (this.location != null) {
            return this.location.toString();
        }
        return "DynamicLocation{null}";
    }

    public boolean isNull() {
        if (this.entity == null && this.location == null) {
            return true;
        }
        if (this.entity != null && this.entity.isDead()) {
            return true;
        }
        return this.location != null && this.location.getWorld() == null;
    }
}

