/*
 * Decompiled with CFR 0.152.
 */
package com.sovdee.skriptparticles.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.bukkit.util.Vector;

public class MathUtil {
    public static final double PHI = Math.PI * (3.0 - Math.sqrt(5.0));
    public static final double PHI_RECIPROCAL = 1.0 / PHI;
    public static final double PHI_SQUARED = PHI * PHI;
    public static final double[] SPHERE_THETA_COS = new double[4096];
    public static final double[] SPHERE_THETA_SIN = new double[4096];
    public static final double EPSILON = 1.0E-4;

    public static double clamp(double value, double min, double max) {
        return Math.max(min, Math.min(max, value));
    }

    public static Set<Vector> calculateFibonacciSphere(int pointCount, double radius) {
        return MathUtil.calculateFibonacciSphere(pointCount, radius, Math.PI);
    }

    public static Set<Vector> calculateFibonacciSphere(int pointCount, double radius, double angleCutoff) {
        double r;
        int i;
        LinkedHashSet<Vector> points = new LinkedHashSet<Vector>();
        double y = 1.0;
        if (angleCutoff > Math.PI) {
            angleCutoff = Math.PI;
        }
        double yLimit = Math.cos(angleCutoff);
        double yStep = 2.0 / (double)pointCount;
        int preCompPoints = Math.min(pointCount, SPHERE_THETA_COS.length);
        for (i = 0; i < preCompPoints; ++i) {
            r = Math.sqrt(1.0 - y * y) * radius;
            points.add(new Vector(r * SPHERE_THETA_COS[i], y * radius, r * SPHERE_THETA_SIN[i]));
            y -= yStep;
            if (!(y <= yLimit)) continue;
            return points;
        }
        if (pointCount > preCompPoints) {
            for (i = preCompPoints; i < pointCount; ++i) {
                r = Math.sqrt(1.0 - y * y) * radius;
                double theta = PHI * (double)i;
                points.add(new Vector(r * Math.cos(theta), y * radius, r * Math.sin(theta)));
                y -= yStep;
                if (!(y <= yLimit)) continue;
                return points;
            }
        }
        return points;
    }

    public static Set<Vector> calculateCircle(double radius, double particleDensity, double cutoffAngle) {
        LinkedHashSet<Vector> points = new LinkedHashSet<Vector>();
        double stepSize = particleDensity / radius;
        for (double theta = 0.0; theta < cutoffAngle; theta += stepSize) {
            points.add(new Vector(Math.cos(theta) * radius, 0.0, Math.sin(theta) * radius));
        }
        return points;
    }

    public static Set<Vector> calculateDisc(double radius, double particleDensity, double cutoffAngle) {
        LinkedHashSet<Vector> points = new LinkedHashSet<Vector>();
        for (double subRadius = particleDensity; subRadius < radius; subRadius += particleDensity) {
            points.addAll(MathUtil.calculateCircle(subRadius, particleDensity, cutoffAngle));
        }
        points.addAll(MathUtil.calculateCircle(radius, particleDensity, cutoffAngle));
        return points;
    }

    public static Set<Vector> calculateHelix(double radius, double height, double slope, int direction, double particleDensity) {
        LinkedHashSet<Vector> points = new LinkedHashSet<Vector>();
        if (radius <= 0.0 || height <= 0.0) {
            return points;
        }
        double loops = Math.abs(height / slope);
        double length = slope * slope + radius * radius;
        double stepSize = particleDensity / length;
        for (double t = 0.0; t < loops; t += stepSize) {
            double x = radius * Math.cos((double)direction * t);
            double z = radius * Math.sin((double)direction * t);
            points.add(new Vector(x, t * slope, z));
        }
        return points;
    }

    public static Set<Vector> calculateLine(Vector start, Vector end, double particleDensity) {
        LinkedHashSet<Vector> points = new LinkedHashSet<Vector>();
        Vector direction = end.clone().subtract(start);
        double length = direction.length();
        double step = length / (double)Math.round(length / particleDensity);
        direction.normalize().multiply(step);
        for (double i = 0.0; i <= length / step; i += 1.0) {
            points.add(start.clone().add(direction.clone().multiply(i)));
        }
        return points;
    }

    public static Set<Vector> calculateRegularPolygon(double radius, double angle, double particleDensity, boolean wireframe) {
        angle = Math.max(angle, 1.0E-4);
        LinkedHashSet<Vector> points = new LinkedHashSet<Vector>();
        double apothem = radius * Math.cos(angle / 2.0);
        double radiusStep = radius / (double)Math.round(apothem / particleDensity);
        if (wireframe) {
            radiusStep = 2.0 * radius;
        } else {
            points.add(new Vector(0, 0, 0));
        }
        for (double subRadius = radius; subRadius >= 0.0; subRadius -= radiusStep) {
            Vector vertex = new Vector(subRadius, 0.0, 0.0);
            for (double i = 0.0; i < Math.PI * 2; i += angle) {
                points.addAll(MathUtil.calculateLine(vertex.clone().rotateAroundY(i), vertex.clone().rotateAroundY(i + angle), particleDensity));
            }
        }
        return points;
    }

    public static Set<Vector> calculateRegularPrism(double radius, double angle, double height, double particleDensity, boolean wireframe) {
        LinkedHashSet<Vector> points = new LinkedHashSet<Vector>();
        Vector vertex = new Vector(radius, 0.0, 0.0);
        for (double i = 0.0; i < Math.PI * 2; i += angle) {
            Vector currentVertex = vertex.clone().rotateAroundY(i);
            for (Vector vector : MathUtil.calculateLine(currentVertex, vertex.clone().rotateAroundY(i + angle), particleDensity)) {
                points.add(vector);
                if (wireframe) {
                    points.add(vector.clone().setY(height));
                    continue;
                }
                points.addAll(MathUtil.calculateLine(vector, vector.clone().setY(height), particleDensity));
            }
            if (!wireframe) continue;
            points.addAll(MathUtil.calculateLine(currentVertex, currentVertex.clone().setY(height), particleDensity));
        }
        return points;
    }

    public static Set<Vector> connectPoints(List<Vector> points, double particleDensity) {
        LinkedHashSet<Vector> connectedPoints = new LinkedHashSet<Vector>();
        for (int i = 0; i < points.size() - 1; ++i) {
            connectedPoints.addAll(MathUtil.calculateLine(points.get(i), points.get(i + 1), particleDensity));
        }
        return connectedPoints;
    }

    private static double ellipseCircumference(double r1, double r2) {
        double a = Math.max(r1, r2);
        double b = Math.min(r1, r2);
        double h = Math.pow(a - b, 2.0) / Math.pow(a + b, 2.0);
        return Math.PI * (a + b) * (1.0 + 3.0 * h / (10.0 + Math.sqrt(4.0 - 3.0 * h)));
    }

    public static List<Vector> calculateEllipse(double r1, double r2, double particleDensity, double cutoffAngle) {
        ArrayList<Vector> points = new ArrayList<Vector>();
        double circumference = MathUtil.ellipseCircumference(r1, r2);
        int steps = (int)Math.round(circumference / particleDensity);
        double theta = 0.0;
        double angleStep = 0.0;
        for (int i = 0; i < steps && !(theta > cutoffAngle); theta += angleStep, ++i) {
            points.add(new Vector(r1 * Math.cos(theta), 0.0, r2 * Math.sin(theta)));
            double dx = r1 * Math.sin(theta + 0.5 * angleStep);
            double dy = r2 * Math.cos(theta + 0.5 * angleStep);
            angleStep = particleDensity / Math.sqrt(dx * dx + dy * dy);
        }
        return points;
    }

    public static Set<Vector> calculateEllipticalDisc(double r1, double r2, double particleDensity, double cutoffAngle) {
        LinkedHashSet<Vector> points = new LinkedHashSet<Vector>();
        int steps = (int)Math.round(Math.max(r1, r2) / particleDensity);
        for (double i = 1.0; i <= (double)steps; i += 1.0) {
            double r = i / (double)steps;
            points.addAll(MathUtil.calculateEllipse(r1 * r, r2 * r, particleDensity, cutoffAngle));
        }
        return points;
    }

    public static Set<Vector> calculateCylinder(double r1, double height, double particleDensity, double cutoffAngle) {
        Set<Vector> points = MathUtil.calculateDisc(r1, particleDensity, cutoffAngle);
        points.addAll(points.stream().map(v -> v.clone().setY(height)).collect(Collectors.toSet()));
        Set<Vector> wall = MathUtil.calculateCircle(r1, particleDensity, cutoffAngle);
        points.addAll(MathUtil.fillVertically(wall, height, particleDensity));
        return points;
    }

    public static Set<Vector> calculateCylinder(double r1, double r2, double height, double particleDensity, double cutoffAngle) {
        Set<Vector> points = MathUtil.calculateEllipticalDisc(r1, r2, particleDensity, cutoffAngle);
        points.addAll(points.stream().map(v -> v.clone().setY(height)).collect(Collectors.toSet()));
        LinkedHashSet<Vector> wall = new LinkedHashSet<Vector>(MathUtil.calculateEllipse(r1, r2, particleDensity, cutoffAngle));
        points.addAll(MathUtil.fillVertically(wall, height, particleDensity));
        return points;
    }

    public static Set<Vector> fillVertically(Set<Vector> vectors, double height, double particleDensity) {
        LinkedHashSet<Vector> points = new LinkedHashSet<Vector>(vectors);
        double heightStep = height / (double)Math.round(height / particleDensity);
        for (double i = 0.0; i < height; i += heightStep) {
            for (Vector vector : vectors) {
                points.add(vector.clone().setY(i));
            }
        }
        return points;
    }

    public static Set<Vector> calculateHeart(double length, double width, double eccentricity, double particleDensity) {
        LinkedHashSet<Vector> points = new LinkedHashSet<Vector>();
        double angleStep = 1.3333333333333333 * particleDensity / (width + length);
        for (double theta = 0.0; theta < Math.PI * 2; theta += angleStep) {
            double x = width * Math.pow(Math.sin(theta), 3.0);
            double y = length * (Math.cos(theta) - 1.0 / eccentricity * Math.cos(2.0 * theta) - 0.16666666666666666 * Math.cos(3.0 * theta) - 0.0625 * Math.cos(4.0 * theta));
            points.add(new Vector(x, 0.0, y));
        }
        return points;
    }

    public static Set<Vector> calculateStar(double innerRadius, double outerRadius, double angle, double particleDensity) {
        LinkedHashSet<Vector> points = new LinkedHashSet<Vector>();
        Vector outerVertex = new Vector(outerRadius, 0.0, 0.0);
        Vector innerVertex = new Vector(innerRadius, 0.0, 0.0);
        for (double theta = 0.0; theta < Math.PI * 2; theta += angle) {
            Vector currentVertex = outerVertex.clone().rotateAroundY(theta);
            points.addAll(MathUtil.calculateLine(currentVertex, innerVertex.clone().rotateAroundY(theta + angle / 2.0), particleDensity));
            points.addAll(MathUtil.calculateLine(currentVertex, innerVertex.clone().rotateAroundY(theta - angle / 2.0), particleDensity));
        }
        return points;
    }

    public static List<List<Vector>> batch(Collection<Vector> toDraw, double millisecondsPerPoint) {
        ArrayList<List<Vector>> batches = new ArrayList<List<Vector>>();
        double totalDuration = 0.0;
        Iterator<Vector> pointsIterator = toDraw.iterator();
        while (pointsIterator.hasNext()) {
            ArrayList<Vector> batch = new ArrayList<Vector>();
            while (totalDuration < 50.0 && pointsIterator.hasNext()) {
                totalDuration += millisecondsPerPoint;
                batch.add(pointsIterator.next());
            }
            totalDuration -= 50.0;
            batches.add(batch);
        }
        return batches;
    }

    static {
        for (int i = 0; i < SPHERE_THETA_COS.length; ++i) {
            MathUtil.SPHERE_THETA_COS[i] = Math.cos(PHI * (double)i);
            MathUtil.SPHERE_THETA_SIN[i] = Math.sin(PHI * (double)i);
        }
    }
}

