/*
 * Decompiled with CFR 0.152.
 */
package com.sovdee.skriptparticles.util;

import ch.njol.skript.Skript;
import ch.njol.skript.aliases.ItemType;
import ch.njol.util.StringUtils;
import com.destroystokyo.paper.ParticleBuilder;
import com.sovdee.skriptparticles.particles.Particle;
import com.sovdee.skriptparticles.util.MathUtil;
import com.sovdee.skriptparticles.util.Quaternion;
import com.sovdee.skriptparticles.util.ReflectionUtils;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bukkit.DyeColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Registry;
import org.bukkit.Vibration;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.Vector;
import org.checkerframework.checker.nullness.qual.Nullable;

public class ParticleUtil {
    private static final Map<String, org.bukkit.Particle> PARTICLES = new HashMap<String, org.bukkit.Particle>();
    private static final Map<org.bukkit.Particle, String> PARTICLE_NAMES = new HashMap<org.bukkit.Particle, String>();
    private static final ParticleBuilder Y_AXIS = new ParticleBuilder(org.bukkit.Particle.REDSTONE).data((Object)new Particle.DustOptions(DyeColor.LIME.getColor(), 0.5f));
    private static final ParticleBuilder X_AXIS = new ParticleBuilder(org.bukkit.Particle.REDSTONE).data((Object)new Particle.DustOptions(DyeColor.RED.getColor(), 0.5f));
    private static final ParticleBuilder Z_AXIS = new ParticleBuilder(org.bukkit.Particle.REDSTONE).data((Object)new Particle.DustOptions(DyeColor.BLUE.getColor(), 0.5f));

    public static Particle getDefaultParticle() {
        return (Particle)new Particle(org.bukkit.Particle.FLAME).count(1).extra(0.0);
    }

    public static String getNamesAsString() {
        ArrayList names = new ArrayList();
        PARTICLES.forEach((s, particle) -> {
            Object name = s;
            if (particle.getDataType() != Void.class) {
                name = (String)name + " [" + ParticleUtil.getDataType(particle) + "]";
            }
            names.add(name);
        });
        Collections.sort(names);
        return StringUtils.join(names, (String)", ");
    }

    public static String getName(org.bukkit.Particle particle) {
        return PARTICLE_NAMES.get(particle);
    }

    public static List<org.bukkit.Particle> getAvailableParticles() {
        return new ArrayList<org.bukkit.Particle>(PARTICLES.values());
    }

    public static @Nullable org.bukkit.Particle parse(String key) {
        if (PARTICLES.containsKey(key)) {
            return PARTICLES.get(key);
        }
        return null;
    }

    private static String getDataType(org.bukkit.Particle particle) {
        Class dataType = particle.getDataType();
        if (dataType == ItemStack.class) {
            return "itemtype";
        }
        if (dataType == Particle.DustOptions.class) {
            return "dust-option";
        }
        if (dataType == BlockData.class) {
            return "blockdata/itemtype";
        }
        if (dataType == Particle.DustTransition.class) {
            return "dust-transition";
        }
        if (dataType == Vibration.class) {
            return "vibration";
        }
        if (dataType == Integer.class) {
            return "number(int)";
        }
        if (dataType == Float.class) {
            return "number(float)";
        }
        return "UNKNOWN";
    }

    public static @Nullable Object getData(org.bukkit.Particle particle, Object data) {
        Class dataType = particle.getDataType();
        if (dataType == Void.class) {
            return null;
        }
        if (dataType == Float.class && data instanceof Number) {
            Number number = (Number)data;
            return Float.valueOf(number.floatValue());
        }
        if (dataType == Integer.class && data instanceof Number) {
            Number number = (Number)data;
            return number.intValue();
        }
        if (dataType == ItemStack.class && data instanceof ItemType) {
            ItemType itemType = (ItemType)data;
            return itemType.getRandom();
        }
        if (dataType == Particle.DustOptions.class && data instanceof Particle.DustOptions) {
            return data;
        }
        if (dataType == Particle.DustTransition.class && data instanceof Particle.DustTransition) {
            return data;
        }
        if (dataType == Vibration.class && data instanceof Vibration) {
            return data;
        }
        if (dataType == BlockData.class) {
            ItemType itemType;
            Material material;
            if (data instanceof BlockData) {
                return data;
            }
            if (data instanceof ItemType && (material = (itemType = (ItemType)data).getMaterial()).isBlock()) {
                return material.createBlockData();
            }
        }
        return null;
    }

    public static ParticleBuilder cloneBuilder(ParticleBuilder builder) {
        return new ParticleBuilder(builder.particle()).count(builder.count()).extra(builder.extra()).offset(builder.offsetX(), builder.offsetY(), builder.offsetZ()).data(builder.data()).force(builder.force()).receivers(builder.receivers()).source(builder.source());
    }

    public static void drawAxes(Location location, Quaternion orientation, Collection<Player> recipients) {
        Set<Vector> yAxis = MathUtil.calculateLine(new Vector(0, 0, 0), new Vector(0, 1, 0), 0.2);
        Set<Vector> xAxis = MathUtil.calculateLine(new Vector(0, 0, 0), new Vector(1, 0, 0), 0.2);
        Set<Vector> zAxis = MathUtil.calculateLine(new Vector(0, 0, 0), new Vector(0, 0, 1), 0.2);
        yAxis = orientation.transform(yAxis);
        xAxis = orientation.transform(xAxis);
        zAxis = orientation.transform(zAxis);
        Y_AXIS.receivers(recipients);
        X_AXIS.receivers(recipients);
        Z_AXIS.receivers(recipients);
        for (Vector vector : yAxis) {
            Y_AXIS.location(location.clone().add(vector)).spawn();
        }
        for (Vector vector : xAxis) {
            X_AXIS.location(location.clone().add(vector)).spawn();
        }
        for (Vector vector : zAxis) {
            Z_AXIS.location(location.clone().add(vector)).spawn();
        }
    }

    static {
        if (Skript.methodExists(org.bukkit.Particle.class, (String)"getKey", (Class[])new Class[0])) {
            Registry.PARTICLE_TYPE.forEach(particle -> {
                String key = particle.getKey().getKey();
                PARTICLES.put(key, (org.bukkit.Particle)particle);
                PARTICLE_NAMES.put((org.bukkit.Particle)particle, key);
            });
        } else {
            @Nullable Class<?> cbParticle = ReflectionUtils.getOBCClass("CraftParticle");
            try {
                assert (cbParticle != null);
                Field bukkitParticleField = cbParticle.getDeclaredField("bukkit");
                bukkitParticleField.setAccessible(true);
                Field mcKeyField = cbParticle.getDeclaredField("minecraftKey");
                mcKeyField.setAccessible(true);
                for (Object enumConstant : cbParticle.getEnumConstants()) {
                    String mcKey = mcKeyField.get(enumConstant).toString().replace("minecraft:", "");
                    org.bukkit.Particle bukkitParticle = (org.bukkit.Particle)bukkitParticleField.get(enumConstant);
                    if (bukkitParticle.toString().contains("LEGACY")) continue;
                    PARTICLES.put(mcKey, bukkitParticle);
                    PARTICLE_NAMES.put(bukkitParticle, mcKey);
                }
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
    }
}

