/*
 * Decompiled with CFR 0.152.
 */
package com.sovdee.skriptparticles.util;

import com.sovdee.skriptparticles.util.DynamicLocation;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.util.Vector;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.jetbrains.annotations.Contract;

public class Point<T> {
    private final T rawValue;
    private final Class<T> type;
    private boolean isDynamic;

    public Point(T value, Class<T> type) {
        this(value, type, false);
    }

    private Point(T value, Class<T> type, boolean isDynamic) {
        this.rawValue = value;
        this.type = type;
        this.isDynamic = isDynamic;
    }

    public static List<Point<?>> of(List<?> values) {
        ArrayList points = new ArrayList();
        for (Object value : values) {
            points.add(Point.of(value));
        }
        return points;
    }

    @Contract(value="!null -> !null")
    public static @Nullable Point<?> of(@Nullable Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Vector) {
            Vector v = (Vector)value;
            return Point.of(v);
        }
        if (value instanceof Entity) {
            Entity v = (Entity)value;
            return Point.of(v);
        }
        if (value instanceof Location) {
            Location v = (Location)value;
            return Point.of(v);
        }
        if (value instanceof DynamicLocation) {
            DynamicLocation v = (DynamicLocation)value;
            return Point.of(v);
        }
        assert (false);
        return null;
    }

    public static Point<Vector> of(Vector value) {
        return new Point<Vector>(value.clone(), Vector.class);
    }

    public static Point<Location> of(Location value) {
        return new Point<Location>(value.clone(), Location.class);
    }

    public static Point<Entity> of(Entity value) {
        return new Point<Entity>(value, Entity.class, true);
    }

    public static Point<DynamicLocation> of(DynamicLocation value) {
        return new Point<DynamicLocation>(value, DynamicLocation.class, value.isDynamic());
    }

    public DynamicLocation getDynamicLocation() {
        if (this.type == Vector.class) {
            return new DynamicLocation();
        }
        if (this.type == Location.class) {
            return new DynamicLocation((Location)this.rawValue);
        }
        if (this.type == Entity.class) {
            return new DynamicLocation((Entity)this.rawValue);
        }
        if (this.type == DynamicLocation.class) {
            return new DynamicLocation((DynamicLocation)this.rawValue);
        }
        assert (false);
        return null;
    }

    @Contract(pure=true)
    public @Nullable Location getLocation() {
        return this.getLocation(null);
    }

    @Contract(value="!null -> new", pure=true)
    public @Nullable Location getLocation(@Nullable Location origin) {
        if (this.type == Vector.class) {
            if (origin == null) {
                return null;
            }
            return origin.clone().add((Vector)this.rawValue);
        }
        if (this.type == Location.class) {
            return ((Location)this.rawValue).clone();
        }
        if (this.type == Entity.class) {
            return ((Entity)this.rawValue).getLocation().clone();
        }
        if (this.type == DynamicLocation.class) {
            return ((DynamicLocation)this.rawValue).getLocation();
        }
        assert (false);
        return null;
    }

    @Contract(value="_ -> new", pure=true)
    public Vector getVector(@Nullable Location origin) {
        if (this.type == Vector.class) {
            return ((Vector)this.rawValue).clone();
        }
        if (origin == null) {
            origin = new Location(null, 0.0, 0.0, 0.0);
        }
        if (this.type == Location.class) {
            return ((Location)this.rawValue).toVector().subtract(origin.toVector());
        }
        if (this.type == Entity.class) {
            return ((Entity)this.rawValue).getLocation().toVector().subtract(origin.toVector());
        }
        if (this.type == DynamicLocation.class) {
            return ((DynamicLocation)this.rawValue).getLocation().toVector().subtract(origin.toVector());
        }
        return new Vector(0, 0, 0);
    }

    public T getRawValue() {
        return this.rawValue;
    }

    public Class<T> getType() {
        return this.type;
    }

    public boolean isDynamic() {
        return this.isDynamic;
    }
}

