/*
 * Decompiled with CFR 0.152.
 */
package com.sovdee.skriptparticles.util;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.bukkit.util.Vector;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class Quaternion
extends Quaternionf
implements Cloneable {
    public static final Quaternion IDENTITY = new Quaternion(0.0f, 0.0f, 0.0f, 1.0f);

    public Quaternion() {
    }

    public Quaternion(double x, double y, double z, double w) {
        super((float)x, (float)y, (float)z, (float)w);
    }

    public Quaternion(float x, float y, float z, float w) {
        super(x, y, z, w);
    }

    public Quaternion(Vector axis, float angle) {
        this.setAngleAxis(angle, (float)axis.getX(), (float)axis.getY(), (float)axis.getZ());
    }

    public Quaternion(Quaternionf quaternion) {
        this.set((Quaternionfc)quaternion);
    }

    public Quaternion(Quaternion quaternion) {
        this.set((Quaternionfc)quaternion);
    }

    public List<Vector> transform(List<Vector> vectors) {
        vectors.replaceAll(this::transform);
        return vectors;
    }

    public Set<Vector> transform(Set<Vector> vectors) {
        HashSet<Vector> newVectors = new HashSet<Vector>();
        for (Vector vector : vectors) {
            newVectors.add(this.transform(vector));
        }
        return newVectors;
    }

    public Vector transform(Vector vector) {
        Vector3f vector3f = new Vector3f((float)vector.getX(), (float)vector.getY(), (float)vector.getZ());
        vector3f = this.transform(vector3f);
        return vector.setX(vector3f.x).setY(vector3f.y).setZ(vector3f.z);
    }

    public Quaternion rotationTo(Vector to) {
        Vector3f vector3f = new Vector3f((float)to.getX(), (float)to.getY(), (float)to.getZ());
        return (Quaternion)this.rotationTo((Vector3fc)new Vector3f(0.0f, 1.0f, 0.0f), (Vector3fc)vector3f);
    }

    public Quaternion rotationTo(Vector from, Vector to) {
        Vector3f vector3f = new Vector3f((float)from.getX(), (float)from.getY(), (float)from.getZ());
        Vector3f vector3f2 = new Vector3f((float)to.getX(), (float)to.getY(), (float)to.getZ());
        return (Quaternion)this.rotationTo((Vector3fc)vector3f, (Vector3fc)vector3f2);
    }

    public Quaternion rotationAxis(float angle, Vector axis) {
        Vector3f vector3f = new Vector3f((float)axis.getX(), (float)axis.getY(), (float)axis.getZ());
        return (Quaternion)this.rotationAxis(angle, (Vector3fc)vector3f);
    }

    public Quaternion clone() {
        return new Quaternion(this);
    }
}

