/*
 * Decompiled with CFR 0.152.
 */
package com.zigythebird.bendable_cuboids.api;

import com.zigythebird.bendable_cuboids.api.Bendable;
import com.zigythebird.bendable_cuboids.impl.Plane;
import net.minecraft.core.Direction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface BendableCube
extends Bendable {
    public void applyBend(float var1);

    default public void applyBendDegrees(float bendValue) {
        this.applyBend(bendValue * ((float)Math.PI / 180));
    }

    @Nullable
    public Direction getBendDirection();

    public int getBendPivot();

    public float getBendX();

    public float getBendY();

    public float getBendZ();

    public Plane getBasePlane();

    public Plane getOtherPlane();

    public float bendHeight();

    default public boolean isBendInverted() {
        Direction direction = this.getBendDirection();
        if (direction == null) {
            return false;
        }
        return direction.getAxisDirection() == Direction.AxisDirection.POSITIVE;
    }

    default public void rebuild(@NotNull Direction direction) {
        this.rebuild(direction, -1);
    }

    public void rebuild(Direction var1, int var2);

    default public void bc$copyState(BendableCube other) {
        Direction direction = other.getBendDirection();
        if (direction != null) {
            this.rebuild(direction, other.getBendPivot());
        }
        if (this.getBendDirection() != null) {
            this.applyBend(other.getBend());
        }
    }
}

