package com.zigythebird.bendable_cuboids.impl.compatibility;

import com.zigythebird.bendable_cuboids.api.BendableCube;
import com.zigythebird.bendable_cuboids.api.BendableModelPart;
import com.zigythebird.bendable_cuboids.impl.BendUtil;
import net.minecraft.class_2350;
import net.minecraft.class_4587;
import net.minecraft.class_630;

public class PlayerBendHelper {
    public static void resetBend(class_630 modelPart) {
        PlayerBendHelper.bend(modelPart, 0);
    }

    public static void bend(class_630 modelPart, float rotation) {
        BendableCube cube = ((BendableModelPart) modelPart).bc$getCuboid(0);
        if (cube == null) return;
        cube.applyBend(rotation);
    }

    public static void initBend(class_630 modelPart, class_2350 direction) {
        BendableCube cube = ((BendableModelPart) modelPart).bc$getCuboid(0);
        if (cube != null) cube.rebuild(direction);
    }

    public static void initBend(class_630 modelPart, class_2350 direction, int pivot) {
        BendableCube cube = ((BendableModelPart) modelPart).bc$getCuboid(0);
        if (cube != null) cube.rebuild(direction, pivot);
    }

    public static void applyTorsoBendToMatrix(class_4587 poseStack, float bend) {
        BendUtil.applyBendToMatrix(poseStack, 0, 0.375F, 0, bend);
    }
}
