/*
 * Decompiled with CFR 0.152.
 */
package com.zigythebird.bendable_cuboids.impl;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.zigythebird.bendable_cuboids.api.BendableCube;
import com.zigythebird.bendable_cuboids.impl.Plane;
import java.util.function.Function;
import net.minecraft.core.Direction;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;

public class BendUtil {
    private static final Vector3f Z_AXIS = new Vector3f(0.0f, 0.0f, 1.0f);

    public static Function<Vector3f, Vector3f> getBend(BendableCube cuboid) {
        return BendUtil.getBend(cuboid, cuboid.getBend());
    }

    public static Function<Vector3f, Vector3f> getBend(BendableCube cuboid, float bendValue) {
        return BendUtil.getBend(cuboid.getBendX(), cuboid.getBendY(), cuboid.getBendZ(), cuboid.getBasePlane(), cuboid.getOtherPlane(), cuboid.isBendInverted(), false, cuboid.bendHeight(), bendValue);
    }

    public static Function<Vector3f, Vector3f> getBend(float bendX, float bendY, float bendZ, Plane basePlane, Plane otherPlane, boolean isBendInverted, boolean mirrorBend, float bendHeight, float bendValue) {
        if (bendValue == 0.0f) {
            return Function.identity();
        }
        if (mirrorBend) {
            bendValue *= -1.0f;
        }
        float finalBend = bendValue;
        Matrix4f transformMatrix = BendUtil.applyBendToMatrix(new Matrix4f(), bendX, bendY, bendZ, bendValue);
        float halfSize = bendHeight / 2.0f;
        return pos -> {
            boolean isAboveNinetyDegrees;
            float distFromBase = Math.abs(basePlane.distanceTo((Vector3f)pos));
            float distFromOther = Math.abs(otherPlane.distanceTo((Vector3f)pos));
            float s = (float)Math.tan(finalBend / 2.0f) * pos.z;
            if (mirrorBend || !isBendInverted) {
                float temp = distFromBase;
                distFromBase = distFromOther;
                distFromOther = temp;
            }
            float v = halfSize - ((isBendInverted ? s < 0.0f : s >= 0.0f) ? Math.min(Math.abs(s) / 2.0f, 1.0f) : Math.abs(s));
            boolean bl = isAboveNinetyDegrees = (double)Math.abs(BendUtil.clampToRadian(finalBend)) > 1.5707;
            if (distFromBase < distFromOther) {
                if (!isAboveNinetyDegrees && distFromBase + distFromOther <= bendHeight && distFromBase > v) {
                    pos.y = bendY + s;
                }
                Vector4f reposVector = new Vector4f((Vector3fc)pos, 1.0f);
                reposVector.mul((Matrix4fc)transformMatrix);
                pos = new Vector3f(reposVector.x, reposVector.y, reposVector.z);
            } else if (!isAboveNinetyDegrees && distFromBase + distFromOther <= bendHeight && distFromOther > v) {
                pos.y = bendY - s;
            }
            return pos;
        };
    }

    public static Function<Vector3f, Vector3f> getBendLegacy(BendableCube cuboid, float bendValue) {
        return BendUtil.getBendLegacy(cuboid.getBendDirection(), cuboid.getBendX(), cuboid.getBendY(), cuboid.getBendZ(), cuboid.getBasePlane(), cuboid.getOtherPlane(), cuboid.isBendInverted(), false, cuboid.bendHeight(), bendValue);
    }

    public static Function<Vector3f, Vector3f> getBendLegacy(Direction bendDirection, float bendX, float bendY, float bendZ, Plane basePlane, Plane otherPlane, boolean isBendInverted, boolean mirrorBend, float bendHeight, float bendValue) {
        if (mirrorBend) {
            bendValue *= -1.0f;
        }
        float finalBend = bendValue;
        Matrix4f transformMatrix = BendUtil.applyBendToMatrix(new Matrix4f(), bendX, bendY, bendZ, bendValue);
        Vector3f directionUnit = bendDirection.step();
        directionUnit.cross((Vector3fc)Z_AXIS);
        Plane bendPlane = new Plane(directionUnit, new Vector3f(bendX, bendY, bendZ));
        float halfSize = bendHeight / 2.0f;
        return pos -> {
            boolean isInBendArea;
            float distFromBend = isBendInverted ? -bendPlane.distanceTo((Vector3f)pos) : bendPlane.distanceTo((Vector3f)pos);
            float distFromBase = basePlane.distanceTo((Vector3f)pos);
            float distFromOther = otherPlane.distanceTo((Vector3f)pos);
            Vector3f x = bendDirection.step();
            if (mirrorBend) {
                float temp = distFromBase;
                distFromBase = distFromOther;
                distFromOther = temp;
                distFromBend *= -1.0f;
            }
            double s = Math.tan(finalBend / 2.0f) * (double)distFromBend;
            boolean bl = isInBendArea = Math.abs(distFromBase) + Math.abs(distFromOther) <= Math.abs(bendHeight);
            if (Math.abs(distFromBase) < Math.abs(distFromOther)) {
                if (isInBendArea) {
                    x.mul((float)((double)(-distFromBase / halfSize) * s));
                    pos.add((Vector3fc)x);
                }
                Vector4f reposVector = new Vector4f((Vector3fc)pos, 1.0f);
                reposVector.mul((Matrix4fc)transformMatrix);
                pos = new Vector3f(reposVector.x, reposVector.y, reposVector.z);
            } else if (isInBendArea) {
                x.mul((float)((double)(-distFromOther / halfSize) * s));
                pos.add((Vector3fc)x);
            }
            return pos;
        };
    }

    public static Matrix4f applyBendToMatrix(Matrix4f transformMatrix, float bendX, float bendY, float bendZ, float bendValue) {
        transformMatrix.translate(bendX, bendY, bendZ);
        transformMatrix.rotateX(bendValue);
        transformMatrix.translate(-bendX, -bendY, -bendZ);
        return transformMatrix;
    }

    public static PoseStack applyBendToMatrix(PoseStack transformMatrix, float bendX, float bendY, float bendZ, float bendValue) {
        transformMatrix.translate(bendX, bendY, bendZ);
        transformMatrix.mulPose((Quaternionfc)Axis.XP.rotation(bendValue));
        transformMatrix.translate(-bendX, -bendY, -bendZ);
        return transformMatrix;
    }

    public static float clampToRadian(float f) {
        double a = Math.PI * 2;
        double b = ((double)f + Math.PI) % (Math.PI * 2);
        if (b < 0.0) {
            b += Math.PI * 2;
        }
        return (float)(b - Math.PI);
    }
}

