/*
 * Decompiled with CFR 0.152.
 */
package com.zigythebird.bendable_cuboids.impl;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.zigythebird.bendable_cuboids.api.BendableCube;
import com.zigythebird.bendable_cuboids.api.SodiumHelper;
import com.zigythebird.bendable_cuboids.impl.BendUtil;
import com.zigythebird.bendable_cuboids.impl.Plane;
import com.zigythebird.bendable_cuboids.impl.Quad;
import com.zigythebird.bendable_cuboids.impl.RememberingPos;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.core.Direction;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class BendableCuboid
extends ModelPart.Cube
implements BendableCube,
SodiumHelper {
    @Nullable
    private final Quad[] sides;
    @Nullable
    private final RememberingPos[] positions;
    protected final float fixX;
    protected final float fixY;
    protected final float fixZ;
    protected final Plane basePlane;
    protected final Plane otherPlane;
    protected final float fullSize;
    protected final Direction direction;
    protected final int pivot;
    protected float bend;
    private boolean useSodiumRendering = true;

    public BendableCuboid(int texCoordU, int texCoordV, float originX, float originY, float originZ, float dimensionX, float dimensionY, float dimensionZ, float growX, float growY, float growZ, boolean mirror, float texScaleU, float texScaleV, Set<Direction> visibleFaces, Direction direction, int pivot) {
        super(texCoordU, texCoordV, originX, originY, originZ, dimensionX, dimensionY, dimensionZ, growX, growY, growZ, mirror, texScaleU, texScaleV, visibleFaces);
        float size;
        ArrayList<Quad> planes = new ArrayList<Quad>();
        HashMap<Vector3f, RememberingPos> positions = new HashMap<Vector3f, RememberingPos>();
        float pminX = this.minX - growX;
        float pminY = this.minY - growY;
        float pminZ = this.minZ - growZ;
        float pmaxX = this.maxX + growX;
        float pmaxY = this.maxY + growY;
        float pmaxZ = this.maxZ + growZ;
        if (mirror) {
            float tmp = pminX;
            pminX = pmaxX;
            pmaxX = tmp;
        }
        Vector3f[] vertices = new Vector3f[]{new Vector3f(pminX, pminY, pminZ), new Vector3f(pmaxX, pminY, pminZ), new Vector3f(pmaxX, pmaxY, pminZ), new Vector3f(pminX, pmaxY, pminZ), new Vector3f(pminX, pminY, pmaxZ), new Vector3f(pmaxX, pminY, pmaxZ), new Vector3f(pmaxX, pmaxY, pmaxZ), new Vector3f(pminX, pmaxY, pmaxZ)};
        float j = texCoordU;
        float k = (float)texCoordU + dimensionZ;
        float l = (float)texCoordU + dimensionZ + dimensionX;
        float m = (float)texCoordU + dimensionZ + dimensionX + dimensionX;
        float n = (float)texCoordU + dimensionZ + dimensionX + dimensionZ;
        float o = (float)texCoordU + dimensionZ + dimensionX + dimensionZ + dimensionX;
        float p = texCoordV;
        float q = (float)texCoordV + dimensionZ;
        float r = (float)texCoordV + dimensionZ + dimensionY;
        if (visibleFaces.contains(Direction.DOWN)) {
            Quad.createAndAddQuads(planes, positions, new Vector3f[]{vertices[5], vertices[4], vertices[1]}, k, p, l, q, texScaleU, texScaleV, mirror);
        }
        if (visibleFaces.contains(Direction.UP)) {
            Quad.createAndAddQuads(planes, positions, new Vector3f[]{vertices[2], vertices[3], vertices[6]}, l, q, m, p, texScaleU, texScaleV, mirror);
        }
        if (visibleFaces.contains(Direction.WEST)) {
            Quad.createAndAddQuads(planes, positions, new Vector3f[]{vertices[0], vertices[4], vertices[3]}, j, q, k, r, texScaleU, texScaleV, mirror);
        }
        if (visibleFaces.contains(Direction.NORTH)) {
            Quad.createAndAddQuads(planes, positions, new Vector3f[]{vertices[1], vertices[0], vertices[2]}, k, q, l, r, texScaleU, texScaleV, mirror);
        }
        if (visibleFaces.contains(Direction.EAST)) {
            Quad.createAndAddQuads(planes, positions, new Vector3f[]{vertices[5], vertices[1], vertices[6]}, l, q, n, r, texScaleU, texScaleV, mirror);
        }
        if (visibleFaces.contains(Direction.SOUTH)) {
            Quad.createAndAddQuads(planes, positions, new Vector3f[]{vertices[4], vertices[5], vertices[7]}, n, q, o, r, texScaleU, texScaleV, mirror);
        }
        this.sides = planes.toArray(new Quad[0]);
        this.positions = positions.values().toArray(new RememberingPos[0]);
        this.iteratePositions(Function.identity());
        this.direction = Objects.requireNonNull(direction);
        this.pivot = pivot;
        direction = Direction.UP;
        Vector3f pivotVec = new Vector3f();
        if (pivot >= 0 && (float)pivot <= (size = direction.step().mul(dimensionX, dimensionY, dimensionZ).length())) {
            pivotVec = direction.step().mul(size - (float)(pivot * 2));
            vertices[6] = vertices[6].sub((Vector3fc)pivotVec);
        }
        this.basePlane = new Plane(direction.step(), vertices[6]);
        this.otherPlane = new Plane(direction.step(), vertices[0]);
        this.fullSize = -direction.step().dot((Vector3fc)vertices[0]) + direction.step().dot((Vector3fc)vertices[6]);
        this.fixX = (dimensionX + this.minX + this.minX - pivotVec.x()) / 2.0f;
        this.fixY = (dimensionY + this.minY + this.minY - pivotVec.y()) / 2.0f;
        this.fixZ = (dimensionZ + this.minZ + this.minZ - pivotVec.z()) / 2.0f;
    }

    @Override
    public void bc$useSodiumRendering(boolean use) {
        this.useSodiumRendering = use;
    }

    public void compile(PoseStack.Pose pose, VertexConsumer buffer, int packedLight, int packedOverlay, int color) {
        if (this.useSodiumRendering && this.bend == 0.0f || this.sides == null) {
            super.compile(pose, buffer, packedLight, packedOverlay, color);
            return;
        }
        for (Quad quad : this.sides) {
            quad.render(pose, buffer, packedLight, packedOverlay, color);
        }
    }

    @Override
    public void applyBend(float bendValue) {
        if (Math.abs(bendValue) < 1.0E-4f) {
            bendValue = 0.0f;
        }
        if (this.bend == bendValue) {
            return;
        }
        this.bend = bendValue;
        this.iteratePositions(BendUtil.getBend(this, bendValue));
    }

    @Override
    public Direction getBendDirection() {
        return this.direction;
    }

    @Override
    public int getBendPivot() {
        return this.pivot;
    }

    @Override
    public float getBendX() {
        return this.fixX;
    }

    @Override
    public float getBendY() {
        return this.fixY;
    }

    @Override
    public float getBendZ() {
        return this.fixZ;
    }

    @Override
    public Plane getBasePlane() {
        return this.basePlane;
    }

    @Override
    public Plane getOtherPlane() {
        return this.otherPlane;
    }

    @Override
    public float bendHeight() {
        return this.fullSize;
    }

    @Override
    public float getBend() {
        return this.bend;
    }

    public void iteratePositions(Function<Vector3f, Vector3f> function) {
        if (this.positions == null) {
            return;
        }
        for (RememberingPos pos : this.positions) {
            pos.setPos(function.apply(pos.getOriginalPos()));
        }
    }

    private void resetBend() {
        if (this.positions == null) {
            return;
        }
        for (RememberingPos pos : this.positions) {
            pos.setPos(pos.getOriginalPos());
        }
    }
}

